package gui;

import java.awt.Color;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;

import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;


//@author  santhosh kumar - santhosh@in.fiorano.com 
//edited by me
public class DropDownButton extends JButton 
                     implements ChangeListener, PopupMenuListener, PropertyChangeListener{ 
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private final JButton mainButton, arrowButton; 
 
    private final JToolBar holder;
    
    private DropDownButton thisRef = this;
    
    private boolean popupVisible = false; 
    
    private JPopupMenu popupMenu;
    private JList list;
    private JLabel itemCountLabel = new JLabel("not empty");
    
    private String doing;
    
    private Vector<SelectionCompleteListener> selListeners;
 
    public DropDownButton(Action action, ListModel listModel) {
    	super("");
    	
    	setFocusable(false);
    	setBorder(null);
    	   	  	
    	selListeners = new Vector<SelectionCompleteListener>(1,1);
    	doing = (String) action.getValue(Action.NAME);
    	
    	mainButton = new JButton(action);
    	mainButton.setText("");
    	//mainButton.setHideActionText(true);
        mainButton.setFocusable(false);
        
        mainButton.addPropertyChangeListener("enabled", this); //NOI18N
    	mainButton.getModel().addChangeListener(this); 
    	
    	arrowButton = new JButton(new ImageIcon(getClass().getResource("icons/dropdown.gif"))); 
        arrowButton.setMargin(new Insets(1,2,1,2));
        arrowButton.setFocusable(false);
            	
    	arrowButton.getModel().addChangeListener(this); 
        arrowButton.addMouseListener(new MouseAdapter() {
        	public void mousePressed(MouseEvent e) {
        		if(arrowButton.isEnabled()) {
        			JPopupMenu popup = getPopupMenu(); 
        			popup.addPopupMenuListener(thisRef);
        			list.setSelectedIndex(0);
        			list.ensureIndexIsVisible(0);
        			changeItemCountLabel(1);
        			popup.show(mainButton, 0, mainButton.getHeight());
        		}
        	}
		     public void mouseReleased(MouseEvent e) {
		    	 if(!arrowButton.contains(e.getPoint())) {
		    		 if(popupVisible)
		    			 fireSelectionCompleteEvent(getAmountSelected());
		    		 popupMenu.setVisible(false);
		    	 }
		     }
        	
        });
        
        arrowButton.addMouseMotionListener(new MouseMotionListener() {
			public void mouseDragged(MouseEvent e) {
				Rectangle visRect = list.getVisibleRect();
				int minX = visRect.x;
				int maxX = visRect.x + visRect.width;
				
				if(list.isShowing()) {
					int xOffset = arrowButton.getLocationOnScreen().x - list.getLocationOnScreen().x;
					int yOffset = arrowButton.getLocationOnScreen().y - list.getLocationOnScreen().y;
					e.translatePoint(xOffset, yOffset);
				}
				int mouseX = e.getX();
				if(mouseX > minX && mouseX < maxX) {
					selectItems(list.locationToIndex(e.getPoint()));
				}
				else {
					cancelSelection();
				}
			}

			public void mouseMoved(MouseEvent arg0) {
			
			}
        });
        
        
        
        holder = new JToolBar();
        holder.setBorder(null);
        holder.setFocusable(false);
        //holder.setRollover(false);
        holder.setFloatable(false);
        
        holder.add(mainButton);
        holder.add(arrowButton);
        
        add(holder);        
       
        popupMenu = new JPopupMenu();
        //popupMenu.setBorder(BorderFactory.createLineBorder(Color.black));
        
        list = new JList(listModel);
        list.addMouseMotionListener(new MouseMotionListener() {
			public void mouseDragged(MouseEvent e) {
				Rectangle visRect = list.getVisibleRect();
				int minX = visRect.x;
				int maxX = visRect.x + visRect.width;
				int mouseX = e.getX();
				if(mouseX > minX && mouseX < maxX) {
					selectItems(list.locationToIndex(e.getPoint()));
				}
				else {
					cancelSelection();
				}
			}

			public void mouseMoved(MouseEvent e) {
				selectItems(list.locationToIndex(e.getPoint()));
			}
        	
        });
        list.addMouseListener(new MouseAdapter() {
		     public void mousePressed(MouseEvent e) {
					selectItems(list.locationToIndex(e.getPoint()));
		     }
		     public void mouseReleased(MouseEvent e) {
	    		 if(popupVisible)
	    			 fireSelectionCompleteEvent(getAmountSelected());
	    		 popupMenu.setVisible(false);
		     }
		 });
        list.setAutoscrolls(true);
        list.setVisibleRowCount(5);
        list.setPrototypeCellValue("12345678901234567890123456789012345678901234567890");
        list.setSelectionMode(ListSelectionModel.SINGLE_INTERVAL_SELECTION);
        
        JScrollPane scroll = new JScrollPane(list, JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        scroll.setBorder(null);
 
        list.setFocusable( false ); 
        scroll.getVerticalScrollBar().setFocusable( false ); 
        scroll.getHorizontalScrollBar().setFocusable( false ); 
 
        popupMenu.setBackground(new Color(220,220, 220));
        
        popupMenu.add(scroll);
        
        popupMenu.setFocusable(false);
        
        itemCountLabel.setBorder(null);
        
        popupMenu.add(itemCountLabel);      
    } 
 
    /*------------------------------[ PropertyChangeListener ]---------------------------------------------------*/ 
    
    public void propertyChange(PropertyChangeEvent evt){ 
        arrowButton.setEnabled(mainButton.isEnabled());
    } 
 
    /*------------------------------[ ChangeListener ]---------------------------------------------------*/ 
 
    public void stateChanged(ChangeEvent e){ 
        if(e.getSource()==mainButton.getModel()){ 
            if(popupVisible && !mainButton.getModel().isRollover()){ 
                mainButton.getModel().setRollover(true); 
                return; 
            } 
            arrowButton.getModel().setRollover(mainButton.getModel().isRollover()); 
            arrowButton.setSelected(mainButton.getModel().isArmed() && mainButton.getModel().isPressed());
        }else{ 
            if(popupVisible && !arrowButton.getModel().isSelected()){ 
                arrowButton.getModel().setSelected(true);
                return; 
            } 
            mainButton.getModel().setRollover(arrowButton.getModel().isRollover()); 
        } 
    } 
 
    /*------------------------------[ PopupMenuListener ]---------------------------------------------------*/ 
 
    public void popupMenuWillBecomeVisible(PopupMenuEvent e){ 
        popupVisible = true; 
        mainButton.getModel().setRollover(true); 
        arrowButton.getModel().setSelected(true); 
    } 
 
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e){ 
        popupVisible = false;
 
        mainButton.getModel().setRollover(false); 
        arrowButton.getModel().setSelected(false); 
        ((JPopupMenu)e.getSource()).removePopupMenuListener(this); // act as good programmer :)
    } 
 
    public void popupMenuCanceled(PopupMenuEvent e){
        popupVisible = false;
    } 
 
    /*------------------------------[ Other Methods ]---------------------------------------------------*/ 
 
    protected JPopupMenu getPopupMenu() {
    	return popupMenu;
    }
 
/*    public JButton addToToolBar(JToolBar toolbar){
        toolbar.add(mainButton); 
        toolbar.add(arrowButton);
        return mainButton; 
    }
*/
    
    
    //added by me
    
    private void selectItems(int last) {
    	list.setSelectionInterval(0, last);
    	list.ensureIndexIsVisible(last);
    	changeItemCountLabel(last+1);
    }
    
    private void changeItemCountLabel(int count) {
    	itemCountLabel.setText(doing + " " + count + " actions");    	
    }
    
    private void cancelSelection() {
    	list.clearSelection();
    	itemCountLabel.setText("Cancel");
    }
    
    private int getAmountSelected() {
    	return list.getMaxSelectionIndex()+1;
    }
    
    public void addSelectionCompleteListener(SelectionCompleteListener scl) {
    	selListeners.add(scl);
    }
    
    public void removeSelectionCompleteListener(SelectionCompleteListener scl) {
    	selListeners.remove(scl);
    }
    
    public void fireSelectionCompleteEvent(int amountSelected) {
    	for(SelectionCompleteListener scl : selListeners) {
    		scl.selectionComplete(amountSelected);
    	}
    }
    
    public interface SelectionCompleteListener {
    	public void selectionComplete(int amountSelected);
    }
    
} 