package gui;

import java.awt.GridLayout;

import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class AddOwnVariantDialog {
	
	UserInput showDialog(JFrame owner, String variant, boolean isInstance) {

		JLabel variantLabel;
		JTextField replacementTF;
		JCheckBox replaceAllInstancesOfWordCB, addRepToDictionaryCB, addVarToUDVCB;
		JPanel main;


		variantLabel = new JLabel("Replace " + variant + " with:");
		replacementTF = new JTextField(15);
		replacementTF.setText(variant);

		replaceAllInstancesOfWordCB =	new JCheckBox("Replace all instances of variant", false);
		addVarToUDVCB =			new JCheckBox("Remember replacement", true);
		addRepToDictionaryCB =		new JCheckBox("Add replacement to dictionary (if not already present)", true);

		if(!isInstance) {
			replaceAllInstancesOfWordCB.setSelected(true);
			replaceAllInstancesOfWordCB.setEnabled(false);
		}

		//build pane
		main = new JPanel(new GridLayout(5,1));
		main.add(variantLabel);
		main.add(replacementTF);
		main.add(replaceAllInstancesOfWordCB);
		main.add(addVarToUDVCB);
		main.add(addRepToDictionaryCB);
		
		replacementTF.selectAll();

		int val = JOptionPane.showConfirmDialog(owner, main, "Replace " + variant, JOptionPane.OK_CANCEL_OPTION, JOptionPane.PLAIN_MESSAGE);

		while(true) {
			if(val == JOptionPane.OK_OPTION) {
				if(!replacementTF.getText().equals("")) {
					return new UserInput(variant, replacementTF.getText(), replaceAllInstancesOfWordCB.isSelected(), addVarToUDVCB.isSelected(), addRepToDictionaryCB.isSelected());
				}
				else {
					JOptionPane.showMessageDialog(owner, "Please enter a replacement", "Error", JOptionPane.WARNING_MESSAGE);
					val = JOptionPane.showConfirmDialog(owner, main, "Replace " + variant, JOptionPane.OK_CANCEL_OPTION, JOptionPane.PLAIN_MESSAGE);				
				}
			}
			else
				return null;
		}
	}


	static class UserInput {
		String variant;
		String replacement;

		boolean addVarToUDV, addRepToDictionary, replaceAllInstancesOfWord;

		private UserInput(String variant, String replacement, boolean replaceAllInstancesOfWord, boolean addVarToUDV, boolean addRepToDictionary) {
			this.variant = variant;
			this.replacement = replacement;
			this.replaceAllInstancesOfWord = replaceAllInstancesOfWord;
			this.addVarToUDV = addVarToUDV;
			this.addRepToDictionary = addRepToDictionary;
		}

		String getVariant() {
			return variant;
		}

		String getReplacement() {
			return replacement;
		}

		boolean isAddVarToUDV() {
			return addVarToUDV;
		}

		boolean isAddRepToDictionary() {
			return addRepToDictionary;
		}

		boolean isReplaceAllInstancesOfWord() {
			return replaceAllInstancesOfWord;
		}
	}
}
