package globals;

import javax.swing.JOptionPane;


public class ExceptionDisplay implements ExceptionMessageHandler {
	
	private static ExceptionDisplay _instance = null;
		
	protected ExceptionDisplay() {
	}
	
	public static ExceptionDisplay getInstance() {
		if(_instance == null)
			_instance = new ExceptionDisplay();
		
		return _instance;
	}
	
	public void showException(String message, Exception ex) {
		JOptionPane.showMessageDialog(null, message + "\n\n" + ex.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
		ex.printStackTrace();
	}
}
