/**
 * 
 */
package doc;

import javax.swing.text.Position;

/**
 * @author barona
 *
 */
public class RealErrorInstance extends VariantInstance {

	public static final int USER_DEFINED = 1;
	public static final int LOW_FREQ = 2;
	private int reason;
	
	public RealErrorInstance() {
		
	}
	
	public RealErrorInstance(Position start, Position end, WordHolder holder, InstanceHolder instanceHolder, String original, int reason) {
		super(start, end, holder, instanceHolder, original);
		this.reason = reason;
		// TODO Auto-generated constructor stub
	}
	
	public RealErrorInstance(Instance oldInstance, int reason) {
		super(oldInstance);
		this.reason = reason;
	}

	/**
	 * @return the reason
	 */
	public int getReason() {
		return reason;
	}
	
	public int getType() {
		return WordHolder.REAL_ERROR;
	}
	
	public boolean removeSelfFromHolder() {
		return holder.removeRealError(this);
	}
	
	public void addSelfToHolder() {
		holder.addRealError(this);
	}
	
	public String insertXMLTags(int offset, String text) {
		String textStart, textEnd, openTag = "", closeTag = "", inBetween;
		
		if(isJoin)
			openTag += "<join original=\"" + joinString + "\">";

		inBetween = original;
		
		if(isJoin)
			closeTag += "</join>";
		
		textStart = text.substring(0,getStartOffset() + offset);
		textEnd = text.substring(getEndOffset() + offset);
		
		return (textStart + openTag + inBetween + closeTag + textEnd);
	}

}
