package doc;

import javax.swing.text.Position;

public class CorrectInstance extends Instance {
	
	public CorrectInstance(Position start, Position end, WordHolder holder, InstanceHolder instanceHolder, String original) {
		super(start, end, holder, instanceHolder, original);
	}
	
	public CorrectInstance(Instance instance) {
		super(instance);
	}
	
	public CorrectInstance() {
		
	}
	
	@Override
	public String insertXMLTags(int offset, String text) {
		String textStart, textEnd, openTag = "", closeTag = "", inBetween;
		
		if(isJoin)
			openTag += "<join original=\"" + joinString + "\">";

		inBetween = original;
		
		if(isJoin)
			closeTag += "</join>";
		
		textStart = text.substring(0,getStartOffset() + offset);
		textEnd = text.substring(getEndOffset() + offset);
		
		return (textStart + openTag + inBetween + closeTag + textEnd);
	}
	
	public int getType() {
		return WordHolder.CORRECT;
	}
	
	public boolean removeSelfFromHolder() {
		return holder.removeCorrect(this);
	}
	
	public void addSelfToHolder() {
		holder.addCorrect(this);
	}
}
