package lookup;

public class WordUtilities {
	public static final int EMPTY = 66;
	public static final int ALL_CAPITALS = 51;
	public static final int NO_CAPITALS = 52;
	public static final int FIRST_CAPITAL = 53;


	public static int getCapitalization(String word) {
		int capitalization;
		if(word==null || word.equals(""))
			return EMPTY;
		if(word.length() == 1) {
			if(Character.isUpperCase(word.charAt(0)))
				return FIRST_CAPITAL;
			else
				return NO_CAPITALS;
		}
		
		
		capitalization = ALL_CAPITALS;
		for(int i=0;i<word.length();i++) {
			if(Character.isLowerCase(word.charAt(i)))
				capitalization = NO_CAPITALS;
		}
		char firstLetter = word.charAt(0);
		if(firstLetter == '\'') {
			firstLetter = word.charAt(1);
		}
		if(capitalization == NO_CAPITALS && Character.isUpperCase(firstLetter))
			return FIRST_CAPITAL;

		return capitalization;
	}

	public static String capitalize(String w, int capitalization) {
		if(w==null || w.equals(""))
			return w;
		String word = new String(w);
		if(capitalization==ALL_CAPITALS)
			return word.toUpperCase();
		else if(capitalization==NO_CAPITALS)
			return word.toLowerCase();
		else if(capitalization==FIRST_CAPITAL)
			return (Character.toUpperCase(word.charAt(0)) + word.substring(1));
		else
			return word;
	}

	public static String getSoundexCode(String word) {
		if(word==null)
			return "";

		int soundexLength = globals.Globals.getInstance().getSoundexCodeLength();		

		String UCWord = new String(word).toUpperCase();

		String toConvert = "";
		int wordLength = UCWord.length();

	//removing unwanted characters

		char currentChar;
		for(int i=0;i<wordLength;i++) {			//remove all non-letters
			currentChar = UCWord.charAt(i);
			if(Character.isLetter(currentChar))
				toConvert += currentChar;
		}

		toConvert.toUpperCase();
		toConvert = toConvert.replaceAll("DG", "G");	//DG -> G
		toConvert = toConvert.replaceAll("GH", "H");	//GH -> H
		toConvert = toConvert.replaceAll("GN", "N");	//GN -> N
		toConvert = toConvert.replaceAll("KN", "N");	//KN -> N
		toConvert = toConvert.replaceAll("PH", "F");	//PH -> F
		toConvert = toConvert.replaceAll("MB", "M");	//MB -> M
		toConvert = toConvert.replaceAll("TCH", "CH");	//TCH -> CH
		if(toConvert.startsWith("PS") || toConvert.startsWith("PF") || toConvert.startsWith("H"))
			toConvert = toConvert.substring(1);	//PS -> S at start of word
								//PF -> F at start of word
								//remove H at start of word


		if(toConvert.equals(""))
			return "";



	//creating soundex code


	//take first letter as first character of code

		String code = toConvert.substring(0,1);
		if(	code.equals("E") ||
			code.equals("I") ||
			code.equals("O") ||
			code.equals("U") )

				code = "A";  //converting any vowel starts to A, so encrease and increase would match for instance

		toConvert = toConvert.substring(1);

	//pad with zeros at end
		for(int i=0;i<soundexLength-1;i++) {
			toConvert += "0";
		}


	//replace letters with relevant no.

		char[] chars = toConvert.toCharArray();
		for(int i=0;i<chars.length;i++) {
			if(	chars[i] == 'A' ||
				chars[i] == 'E' ||
				chars[i] == 'I' ||
				chars[i] == 'O' ||
				chars[i] == 'U' ||
				chars[i] == 'H' ||
				chars[i] == 'W' ||
				chars[i] == 'Y'
			)
				chars[i] = '0';

			else if(	chars[i] == 'B' ||
					chars[i] == 'F' ||
					chars[i] == 'P' ||
					chars[i] == 'V'
			)
				chars[i] = '1';

			else if(	chars[i] == 'C' ||
					chars[i] == 'G' ||
					chars[i] == 'J' ||
					chars[i] == 'K' ||
					chars[i] == 'Q' ||
					chars[i] == 'S' ||
					chars[i] == 'X' ||
					chars[i] == 'Z'
			)
				chars[i] = '2';
			
			else if(	chars[i] == 'D' ||
					chars[i] == 'T'
			)
				chars[i] = '3';

			else if(	chars[i] == 'L'
			)
				chars[i] = '4';

			else if(	chars[i] == 'M' ||
					chars[i] == 'N'
			)
				chars[i] = '5';

			else if(	chars[i] == 'R'
			)
				chars[i] = '6';
		}


	//reduce pairs of same no. to 1 no.

		code += chars[0];

		for(int i=1;i<chars.length;i++) {
			if(chars[i] != chars[i-1])
				code += chars[i];
		}

		code = code.replaceAll("0","");

	//pad with zeros at end
		for(int i=0;i<soundexLength-1;i++) {
			code += "0";
		}

		return code.substring(0,soundexLength);
	}


	public static int getEditDistance(String word1, String word2) { //returns the number of deletions, insertions and substitutions required to turn word1 into word2
	//for comparison set all letters to upper case
		char[] s = new String(word1).toUpperCase().toCharArray();
		char[] t = new String(word2).toUpperCase().toCharArray();
		int sLength = s.length;
		int tLength = t.length;

	//if one of the strings is empty, the distance is simply the length of the other string
		if(sLength == 0)
			return tLength;
		if(tLength == 0)
			return sLength;

		int[][] matrix = new int[sLength+1][tLength+1];
		for(int i=0;i<sLength;i++) {
			matrix[i][0] = i;
		}
		for(int i=1;i<tLength;i++) {
			matrix[0][i] = i;
		}

		int currentCost;
		int aValue, bValue, cValue, chosenValue;

	//i and j represent place in string, the matrix has an extra and column, so current position is i+1,j+1

		for(int i=0;i<sLength;i++) {
			for(int j=0;j<tLength;j++) {
				if(s[i] == t[j])
					currentCost = 0;
				else
					currentCost = 1;

				aValue = matrix[i][j+1] + 1;
				bValue = matrix[i+1][j] + 1;
				cValue = matrix[i][j] + currentCost;

				chosenValue = aValue;
				if(bValue<chosenValue)
					chosenValue = bValue;
				if(cValue<chosenValue)
					chosenValue = cValue;

				matrix[i+1][j+1] = chosenValue;
			}
		}

		return matrix[sLength][tLength];
	}

	public static boolean isLikelyReplacement(String original, String rep, int editDistance) {
		if(original.equals(rep)) {
			return false;
		}
		return true;
/*		if(editDistance < 3)
			return true;

	//	if(editDistance > 5)
	//		return false;

		double averageLength = (original.length() + rep.length())/2.0;

		if(editDistance > averageLength/2.0)
			return false;
		else
			return true;
			*/
	}	

	public static boolean isValidWord(String word) {
		if(word.length()<2)
			return false;
		for(int i=0;i<word.length();i++) {
			if(!isValidCharacter(word.charAt(i)))
				return false;
		}

		if(word.contains("--"))
			return false;

		return true;
	}

	public static boolean isLetter(char letter) {
		if(letter == '\'' || letter == '' || letter == '')
			return true;
		else
			return Character.isLetter(letter);
	}

	public static boolean isValidCharacter(char letter) {
		if(letter == ' ' || letter == '-')
			return true;
		else
			return isLetter(letter);
	}
}
