package lookup;

import java.util.TreeSet;

public class SoundexHolder extends Node {

	private static final long serialVersionUID = 7030014296928387061L;
	private TreeSet<Word> words;
	private String soundexString;
	
	public SoundexHolder(String ss, Node node) {
		super(ss.charAt(ss.length()-1));
		if(node!=null)
			next = node.next;
		this.soundexString = ss;
		words = new TreeSet<Word>();
	}
	
	boolean isWord() {
		return true;
	}

	/**
	 * @return the words
	 */
	TreeSet<Word> getWords() {
		return words;
	}
	
	boolean addWord(Word word) { //returns true if added
		if(words.contains(word))
			return false;
		
		words.add(word);
		return true;
	}

	/**
	 * @return the soundexString
	 */
	String getSoundexString() {
		return soundexString;
	}
}
