package gui;

import globals.UserMessageListener;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;


public class ProcessingScreen implements UserMessageListener {
	private JProgressBar progressBar;
	private JLabel label;
	private JFrame frame;
	
	private static ProcessingScreen _instance = null;
	
	public static ProcessingScreen getInstance() {
		if(_instance == null)
			_instance = new ProcessingScreen();
		
		return _instance;
	}
	
	protected ProcessingScreen() {
		setup();
	}
	
	private void show() {
		frame.setVisible(true);
	}
	
	private void hide() {
		frame.setVisible(false);
	}

	private void setText(String text) {
			label.setText(text);
	}

	private void setup() {
		label = new JLabel(gui.MainScreen.LOADING_ICON);
		label.setFont(new Font("Verdana", Font.BOLD, 14));
		progressBar = new JProgressBar();
		progressBar.setIndeterminate(true);
		
		frame = new JFrame("Processing...");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		Rectangle maxWinSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
		frame.setLocation((maxWinSize.width/2)-150, (maxWinSize.height/2)-75);
		frame.setSize(300,150);
		frame.setResizable(false);
		frame.getContentPane().add(label, BorderLayout.CENTER);
		frame.getContentPane().add(progressBar, BorderLayout.SOUTH);
	}

	public void finishMessages() {
		setText("");
		hide();	
	}

	public void writeMessage(final String message) {
		setText(message);
		show();
	}
}
