/**
 * 
 */
package gui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintStream;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;


/**
 * @author barona
 *
 */
public class GUISelector extends JFrame implements ActionListener {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	static final Dimension SCREEN_SIZE = Toolkit.getDefaultToolkit().getScreenSize();
	
	JButton[] buttons = new JButton[2];
	
	private static globals.Globals global;
	
	public GUISelector() {
		super();
		
		setTitle("Select User Interface");
	
		buttons[0] = new JButton("Interactive");
		buttons[1] = new JButton("Batch");
		
		JPanel main = new JPanel(new GridLayout(buttons.length,1));
		
		for(int i=0;i<buttons.length;i++) {
			main.add(buttons[i]);
			buttons[i].addActionListener(this);		
			buttons[i].setFont(new Font("Verdana", Font.BOLD, 20));
		}

		setSize(buttons.length*200,200);
		
		setDefaultCloseOperation(EXIT_ON_CLOSE);
		setContentPane(main);
		setLocation(SCREEN_SIZE.width/2 - getWidth()/2, SCREEN_SIZE.height/2 - getHeight()/2);
		setVisible(true);
	}
	
	public static void main(String[] args) {
		
		
		//must be done before anything else because global sets up loading screen gui
		try {
			javax.swing.UIManager.setLookAndFeel(javax.swing.UIManager.getSystemLookAndFeelClassName());
		}
		catch(Exception ex) {
			JOptionPane.showMessageDialog(null, "Error occurred setting look and feel.\n\n" + ex.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
		}		
		
		global = globals.Globals.getInstance();
		
		try {
			File outFile = new File("output.txt");
			PrintStream outStream = new PrintStream(outFile);
			System.setOut(outStream);
			System.setErr(outStream);
		}
		catch(Exception ex) {
			global.exceptionHandler.showException("Error occurred creating output file.", ex);
		}
		
		new GUISelector();

	}
 
	public void actionPerformed(ActionEvent ae) {
		if(ae.getSource() == buttons[0]) {
			dispose();
			Thread thread = new Thread() {
				public void run() {
					try {
						MainScreen.run();
					}
					catch(Exception ex) {
						global.exceptionHandler.showException("Unhandled exception occurred.", ex);
					}
				}
			};
			thread.start();
		}
		else if(ae.getSource() == buttons[1]) {
			dispose();
			Thread thread = new Thread() {
				public void run() {
					try {
						BatchScreen.run();
					}
					catch(Exception ex) {
						global.exceptionHandler.showException("Unhandled exception occurred.", ex);
					}
				}
			};
			thread.start();
		}
		
	}

}
