package globals;

public class Globals {

	private static Globals _instance = null;
	
	private int soundexCodeLength = 4; //min 4, max 6
	
	public UserMessageListener processingMessager;
	public ExceptionMessageHandler exceptionHandler;
	
	public static final String NEW_LINE = System.getProperty("line.separator");
	
	protected Globals() {
		processingMessager = gui.ProcessingScreen.getInstance();
		exceptionHandler = ExceptionDisplay.getInstance();
	}
	
	public static Globals getInstance() {
		if(_instance == null)
			_instance = new Globals();
		
		return _instance;
	}
	
	public int getSoundexCodeLength() {
		return soundexCodeLength;
	}

	public void setSoundexCodeLength(int length) throws IllegalArgumentException { //length must be between 4 and 6 (inc.) otherwise an exception is thrown
		if(length<4)
			throw new IllegalArgumentException("Length below 4");
		else if(length>6)
			throw new IllegalArgumentException("Length over 6");
		else
			soundexCodeLength = length;
	}
}
