/**
 * 
 */
package doc;

import javax.swing.text.Position;

/**
 * @author barona
 *
 */
public class VariantInstance extends Instance {

	VariantInstance(Position start, Position end, WordHolder holder, InstanceHolder instanceHolder, String original)	{
		super(start, end, holder, instanceHolder, original);
	}
	
	VariantInstance(Instance instance) {
		super(instance);
	}
	
	public VariantInstance() {
		
	}
	
	/* (non-Javadoc)
	 * @see doc.Instance#insertXMLTags(int, java.lang.String)
	 */
	@Override
	public String insertXMLTags(int offset, String text) {
		String textStart, textEnd, openTag = "", closeTag = "", inBetween;
		
		if(isJoin)
			openTag += "<join original=\"" + joinString + "\">";
		
		openTag += "<variant>";
		closeTag += "</variant>";
		inBetween = original;
		
		if(isJoin)
			closeTag += "</join>";
		
		textStart = text.substring(0,getStartOffset() + offset);
		textEnd = text.substring(getEndOffset() + offset);
		
		return (textStart + openTag + inBetween + closeTag + textEnd);
	}
	
	public int getType() {
		return WordHolder.VARIANT;
	}
	
	public boolean removeSelfFromHolder() {
		return holder.removeVariant(this);
	}
	
	public void addSelfToHolder() {
		holder.addVariant(this);
	}
}
