/**
 * 
 */
package doc;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import lookup.SuggestedReplacement;

/**
 * @author barona
 *
 */
public class ReplacedInstance extends Instance {

	private SuggestedReplacement replacement;
	private String replacementString;
	private VariantInstance previousInstance;
	
	public ReplacedInstance(VariantInstance instance, InstanceHolder<ReplacedInstance> instanceHolder, SuggestedReplacement replacement) {
		super(instance);
		this.instanceHolder = instanceHolder;
		if(replacement == null)
			throw new NullPointerException("Replacement Null");
		else {
			this.replacement = replacement;
			replacement.setCapitalization(capitalization);
			this.replacementString = replacement.getReplacementString();
			previousInstance = instance;
		}
	}
	
	/* (non-Javadoc)
	 * @see doc.Instance#insertXMLTags(int, java.lang.String)
	 */
	@Override
	public String insertXMLTags(int offset, String text) {
		String textStart, textEnd, openTag = "", closeTag = "", inBetween;
		
		if(isJoin)
			openTag += "<join original=\"" + joinString + "\">";

			
		String xml = ("<replaced variant=\"" + original + "\" foundBy=\"");
		if(replacement.isKnownVariant())
			if(replacement.isUserAdded())
				xml += "u";
			else
				xml += "p";
		if(replacement.isLetterReplacement())
			xml += "l";
		if(replacement.isSoundex())
			xml += "s";

		xml += "\" replacementType=\"";
		if(replacement.isReplacementUserAdded())
			xml += "u";
		else
			xml += "p";

		if(replacement.isInDictionary())
			xml += "r";
		else
			xml += "n";

		xml += ("\" ed=\"" + replacement.getEditDistance() + "\">");

		openTag += xml;
		closeTag += "</replaced>";
			
		inBetween = replacementString;
				
		if(isJoin)
			closeTag += "</join>";
		
		textStart = text.substring(0,getStartOffset() + offset);
		textEnd = text.substring(getEndOffset() + offset);
		
		return (textStart + openTag + inBetween + closeTag + textEnd);
	}
	
	public String toString() {
		return original + " -> " + replacementString;
	}
	
	public String revertString() {
		return original + " <- " + replacementString;
	}
	
	public void setupInText(boolean replaceInText) throws BadLocationException {
		//replacement.addUse(this);
		if(replaceInText) {
			AttributeSet atts = getAttributesAtStart();
			//changed to previous incase join has been done, which only acts on variant instance
			int startInt = previousInstance.getStartOffset();
			doc.remove(startInt, original.length());
			doc.insertString(startInt,replacementString, atts);
			start = doc.createPosition(startInt);
			end = doc.createPosition(startInt+replacementString.length());
			previousInstance.start = start;
			previousInstance.end = end;
		}
		else {
			end = doc.createPosition(getStartOffset()+replacementString.length());
		}
	}
	
	public void revertInText() throws BadLocationException {
		//replacement.minusUse(this);
		AttributeSet atts = getAttributesAtStart();
		int startInt = getStartOffset();
		doc.remove(startInt, replacementString.length());
		doc.insertString(startInt, original, atts);
		previousInstance.start = doc.createPosition(startInt);
		previousInstance.end = doc.createPosition(startInt+original.length());
		start = previousInstance.start;
		end = previousInstance.end;
		//replacement = null;
		//replacementString = null;
	}
	
	private AttributeSet getAttributesAtStart() {
		return doc.getCharacterElement(getStartOffset()).getAttributes();
	}

	/**
	 * @return the replacement
	 */
	public SuggestedReplacement getReplacement() {
		return replacement;
	}

	/**
	 * @return the replacementString
	 */
	public String getReplacementString() {
		return replacementString;
	}
	
	public int compareAlphabeticallyTo(Instance other) {
		int c;
		if ((c = super.compareAlphabeticallyTo(other)) == 0) {
			return replacementString.compareToIgnoreCase(((ReplacedInstance) other).replacementString);
		}
		else
			return c;
	}
	

	public int getType() {
		return WordHolder.REPLACED;
	}

	/**
	 * @return the previousInstance
	 */
	public VariantInstance getPreviousInstance() {
		return previousInstance;
	}

	@Override
	public boolean removeSelfFromHolder() {
		return false;
	}

	@Override
	public void addSelfToHolder() {
		// TODO Auto-generated method stub
	}

}
