/*
 * Decompiled with CFR 0.152.
 */
package ucrelsemtaggergui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import ucrelsemtaggergui.OpenSaveFile;

public class WorkBenchBasic
extends JFrame {
    String newBarText = "";
    private JTextField tf;
    protected JTextField text_field1 = new JTextField();
    protected JTextField text_field2 = new JTextField();
    protected JTextField text_field3 = new JTextField();
    private JSplitPane jSplitPane1 = new JSplitPane();
    protected Font left_font = new Font("TimesRoman", 0, 16);
    protected Font right_font = new Font("TimesRoman", 0, 16);
    private DataOutputStream outf;
    private DataInputStream inf;
    protected static String CURRENT_DIRECTORY = "";
    protected static String CURRENT_DIRECTORY2 = "";
    protected static String leftWindow = new String("Untitled");
    protected static String rightWindow = new String("Untitled");
    private JToolTip tooltip;
    private JComboBox fontNames;
    private JComboBox fontSizes;
    private JComboBox encoding_list;
    private JComboBox languages;
    private JMenuItem fname_format1;
    private JMenuItem fname_format2;
    private Color color = Color.white;
    protected String cur_font_name = "Times New Roman";
    protected int cur_font_size = 16;
    protected static String cur_encoding = "UTF8";
    protected static String language = "English";
    public static String status_bar_text = "Status Bar";
    private static int Table_Counter = 0;
    protected JMenuBar jmb;
    protected JMenu file_menu;
    protected JMenu tools_menu;
    protected JMenu view_menu;
    protected JTextArea jt1 = new JTextArea();
    protected JTextArea jt2 = new JTextArea();
    protected JLabel statusBar = new JLabel();
    private JCheckBoxMenuItem linewrap_l;
    private JCheckBoxMenuItem linewrap_r;
    private OpenSaveFile osf = new OpenSaveFile();

    public WorkBenchBasic() {
        String osName = System.getProperty("os.name");
        if (osName.contains("Mac")) {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        this.setTitle("Corpus Workbench");
        this.statusBar.setText(status_bar_text);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public WorkBenchBasic(String wintitle) {
        this.setTitle(wintitle);
        this.statusBar.setText(status_bar_text);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.tooltip = new JToolTip();
        this.tooltip.setBackground(Color.yellow);
        this.jmb = new JMenuBar();
        this.setJMenuBar(this.jmb);
        this.file_menu = new JMenu("File");
        JMenuItem new_item = new JMenuItem("Clear left window");
        new_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Runnable lwCleanerRunnable = new Runnable(){

                    public void run() {
                        WorkBenchBasic.this.jt1.setText("");
                        leftWindow = "Untitled";
                        WorkBenchBasic.this.updateTitle();
                    }
                };
                SwingUtilities.invokeLater(lwCleanerRunnable);
            }
        });
        JMenuItem new_item2 = new JMenuItem("Clear right window");
        new_item2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Runnable rwCleanerRunnable = new Runnable(){

                    public void run() {
                        WorkBenchBasic.this.jt2.setText("");
                        rightWindow = "Untitled";
                        WorkBenchBasic.this.updateTitle();
                    }
                };
                SwingUtilities.invokeLater(rwCleanerRunnable);
            }
        });
        JMenuItem open_item = new JMenuItem("Open in left window");
        open_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Runnable openFLeft = new Runnable(){

                    public void run() {
                        WorkBenchBasic.this.openFile(1, WorkBenchBasic.this.jt1);
                    }
                };
                SwingUtilities.invokeLater(openFLeft);
            }
        });
        JMenuItem open_item2 = new JMenuItem("Open in right window");
        open_item2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Runnable openFRight = new Runnable(){

                    public void run() {
                        WorkBenchBasic.this.openFile(2, WorkBenchBasic.this.jt2);
                    }
                };
                SwingUtilities.invokeLater(openFRight);
            }
        });
        JMenuItem save_item = new JMenuItem("Save left window as");
        save_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Runnable saveFLeft = new Runnable(){

                    public void run() {
                        WorkBenchBasic.this.saveText(1, WorkBenchBasic.this.jt1);
                    }
                };
                SwingUtilities.invokeLater(saveFLeft);
            }
        });
        JMenuItem save_item2 = new JMenuItem("Save right window as");
        save_item2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Runnable saveFRight = new Runnable(){

                    public void run() {
                        WorkBenchBasic.this.saveText(2, WorkBenchBasic.this.jt2);
                    }
                };
                SwingUtilities.invokeLater(saveFRight);
            }
        });
        JMenuItem exit_item = new JMenuItem("Exit");
        exit_item.setMnemonic('x');
        exit_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        this.file_menu.add(new_item);
        this.file_menu.add(open_item);
        this.file_menu.add(save_item);
        this.file_menu.addSeparator();
        this.file_menu.add(new_item2);
        this.file_menu.add(open_item2);
        this.file_menu.add(save_item2);
        this.file_menu.addSeparator();
        this.file_menu.add(exit_item);
        this.jmb.add(this.file_menu);
        this.view_menu = new JMenu("View");
        this.linewrap_l = new JCheckBoxMenuItem("Wrap Line in Left Window", true);
        this.view_menu.add(this.linewrap_l);
        this.linewrap_l.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Runnable wrapLineLeft = new Runnable(){

                    public void run() {
                        WorkBenchBasic.this.jt1.setLineWrap(WorkBenchBasic.this.linewrap_l.getState());
                    }
                };
                SwingUtilities.invokeLater(wrapLineLeft);
            }
        });
        this.linewrap_r = new JCheckBoxMenuItem("Wrap Line in Right Window", true);
        this.view_menu.add(this.linewrap_r);
        this.linewrap_r.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Runnable wrapLineRight = new Runnable(){

                    public void run() {
                        WorkBenchBasic.this.jt2.setLineWrap(WorkBenchBasic.this.linewrap_r.getState());
                    }
                };
                SwingUtilities.invokeLater(wrapLineRight);
            }
        });
        this.view_menu.addSeparator();
        JMenuItem fground = new JMenuItem("Foreground");
        fground.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Runnable fground = new Runnable(){

                    public void run() {
                        WorkBenchBasic.this.color = JColorChooser.showDialog(WorkBenchBasic.this, "Choose a colour", WorkBenchBasic.this.color);
                        if (WorkBenchBasic.this.color != null) {
                            WorkBenchBasic.this.jt1.setForeground(WorkBenchBasic.this.color);
                            WorkBenchBasic.this.jt2.setForeground(WorkBenchBasic.this.color);
                        }
                    }
                };
                SwingUtilities.invokeLater(fground);
            }
        });
        this.view_menu.add(fground);
        JMenuItem bground = new JMenuItem("Background");
        bground.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Runnable bground = new Runnable(){

                    public void run() {
                        WorkBenchBasic.this.color = JColorChooser.showDialog(WorkBenchBasic.this, "Choose a colour", WorkBenchBasic.this.color);
                        if (WorkBenchBasic.this.color != null) {
                            WorkBenchBasic.this.jt1.setBackground(WorkBenchBasic.this.color);
                            WorkBenchBasic.this.jt2.setBackground(WorkBenchBasic.this.color);
                        }
                    }
                };
                SwingUtilities.invokeLater(bground);
            }
        });
        this.view_menu.add(bground);
        this.jmb.add(this.view_menu);
        JMenu help_menu = new JMenu("Help");
        this.jmb.add(help_menu);
        JMenuItem readme = new JMenuItem("Readme");
        help_menu.add(readme);
        readme.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorkBenchBasic.this.displayHelp();
            }
        });
        JMenuItem aboutme = new JMenuItem("About this tool");
        help_menu.addSeparator();
        help_menu.add(aboutme);
        aboutme.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Runnable aboutTool = new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(WorkBenchBasic.this, "Semantic Tagger Workbench is Developed at UCREL, Lancaster University, UK.\nThis is tool free for non-commercial use only.\nAuthor: Dr. Scott Piao (s.piao@lancaster.ac.uk)\nLast updated: 30 April 2018.\n");
                    }
                };
                SwingUtilities.invokeLater(aboutTool);
            }
        });
        Dimension d = new Dimension(40, 200);
        this.jt1.setFont(this.left_font);
        this.jt1.setMinimumSize(d);
        this.jt2.setMinimumSize(d);
        this.jt2.setFont(this.right_font);
        this.jSplitPane1.setOrientation(1);
        this.jSplitPane1.setContinuousLayout(true);
        this.jSplitPane1.setDividerSize(3);
        JToolBar buttonBar = new JToolBar();
        this.encoding_list = new JComboBox<String>(new String[]{"UTF8", "ASCII", "UTF-16", "Cp1251", "GBK", "BIG5", "EUC_KR", "SJIS", "UnicodeBig", "UnicodeLittle", "Cp1252", "ISO8859_1", "KOI8_R", "Cp1250", "Cp284"});
        this.encoding_list.setMaximumSize(this.encoding_list.getPreferredSize());
        this.encoding_list.setEditable(true);
        this.encoding_list.setToolTipText("Text Encodings");
        this.encoding_list.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Runnable selectFont = new Runnable(){

                    public void run() {
                        cur_encoding = WorkBenchBasic.this.encoding_list.getSelectedItem().toString();
                    }
                };
                SwingUtilities.invokeLater(selectFont);
            }
        });
        buttonBar.add(this.encoding_list);
        this.fontSizes = new JComboBox<String>(new String[]{"6", "8", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"});
        this.fontSizes.setSelectedItem(new Integer(this.cur_font_size).toString());
        this.fontSizes.setMaximumSize(this.fontSizes.getPreferredSize());
        this.fontSizes.setEditable(true);
        this.fontSizes.setToolTipText("Font Sizes");
        this.fontSizes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Runnable setFontSize = new Runnable(){

                    public void run() {
                        int font_size = 0;
                        try {
                            font_size = Integer.parseInt(WorkBenchBasic.this.fontSizes.getSelectedItem().toString());
                        }
                        catch (NumberFormatException ne) {
                            return;
                        }
                        WorkBenchBasic.this.cur_font_size = font_size;
                        Font ft = new Font(WorkBenchBasic.this.cur_font_name, 0, WorkBenchBasic.this.cur_font_size);
                        WorkBenchBasic.this.jt1.setFont(ft);
                        WorkBenchBasic.this.jt2.setFont(ft);
                    }
                };
                SwingUtilities.invokeLater(setFontSize);
            }
        });
        buttonBar.addSeparator();
        buttonBar.add(this.fontSizes);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fonts = ge.getAvailableFontFamilyNames();
        this.fontNames = new JComboBox<String>(fonts);
        this.fontNames.setSelectedItem(this.cur_font_name);
        this.fontNames.setMaximumSize(this.fontNames.getPreferredSize());
        this.fontNames.setEditable(true);
        this.fontNames.setToolTipText("Fonts");
        this.fontNames.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Runnable setFont = new Runnable(){

                    public void run() {
                        WorkBenchBasic.this.cur_font_name = WorkBenchBasic.this.fontNames.getSelectedItem().toString();
                        Font ft = new Font(WorkBenchBasic.this.cur_font_name, 0, WorkBenchBasic.this.cur_font_size);
                        WorkBenchBasic.this.jt1.setFont(ft);
                        WorkBenchBasic.this.jt1.setText(WorkBenchBasic.this.jt1.getText());
                        WorkBenchBasic.this.jt2.setFont(ft);
                        WorkBenchBasic.this.jt2.setText(WorkBenchBasic.this.jt2.getText());
                        Font ft2 = new Font(WorkBenchBasic.this.cur_font_name, 0, 14);
                        WorkBenchBasic.this.text_field1.setFont(ft2);
                        WorkBenchBasic.this.text_field2.setFont(ft2);
                        WorkBenchBasic.this.text_field3.setFont(ft2);
                    }
                };
                SwingUtilities.invokeLater(setFont);
            }
        });
        buttonBar.addSeparator();
        buttonBar.add(this.fontNames);
        buttonBar.add(Box.createGlue());
        Box topBox = new Box(1);
        topBox.add(buttonBar);
        this.getContentPane().add((Component)topBox, "North");
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.getContentPane().add((Component)this.statusBar, "South");
        this.jt1.setLineWrap(true);
        this.jt1.setWrapStyleWord(true);
        this.jt2.setLineWrap(true);
        this.jt2.setWrapStyleWord(true);
        this.jSplitPane1.add((Component)new JScrollPane(this.jt1), "left");
        this.jSplitPane1.add((Component)new JScrollPane(this.jt2), "right");
        this.jSplitPane1.setDividerLocation(425);
    }

    protected void displayHelp() {
        File fl = new File("./readme.txt");
        if (fl == null || fl.getName().equals("")) {
            JOptionPane.showMessageDialog(this, "No readme file available!", "Error", 0);
        } else {
            this.jt1.setText(WorkBenchBasic.readTextFromFile(fl, "UTF8"));
        }
    }

    protected File getFileFromChooser(String title, String path) {
        JFileChooser sf = CURRENT_DIRECTORY.equals("") ? new JFileChooser(System.getProperty("user.home")) : new JFileChooser(CURRENT_DIRECTORY);
        FileFilter def = sf.getFileFilter();
        sf.setDialogTitle(title);
        sf.setFileFilter(def);
        sf.setFileSelectionMode(2);
        if (sf.showOpenDialog(this) != 0) {
            return null;
        }
        File file = sf.getSelectedFile();
        if (file == null || file.getName().equals("")) {
            JOptionPane.showMessageDialog(this, "Invalid Filename", "Error", 0);
        }
        CURRENT_DIRECTORY = file.getPath();
        return file;
    }

    protected File[] getFilesFromChooser(String title, String path) {
        JFileChooser sf = CURRENT_DIRECTORY.equals("") ? new JFileChooser(System.getProperty("user.home")) : new JFileChooser(CURRENT_DIRECTORY);
        FileFilter def = sf.getFileFilter();
        sf.setDialogTitle(title);
        sf.setFileFilter(def);
        sf.setFileSelectionMode(2);
        sf.setMultiSelectionEnabled(true);
        if (sf.showOpenDialog(this) != 0) {
            return null;
        }
        File[] files = sf.getSelectedFiles();
        CURRENT_DIRECTORY = files[0].getPath();
        return files;
    }

    private void search(JTextArea jt) {
        String find_item = JOptionPane.showInputDialog(this, (Object)"Enter an item for search:");
        String text_left = jt.getText();
        int start = text_left.indexOf(find_item, jt.getCaretPosition());
        if (start < 0) {
            return;
        }
        int end = start + find_item.length();
        jt.select(start, end);
    }

    private void openFile(int signal, JTextArea t) {
        File[] filename = signal == 1 ? this.getFilesFromChooser("Select File(s)", CURRENT_DIRECTORY) : this.getFilesFromChooser("Select File(s)", CURRENT_DIRECTORY2);
        if (filename == null) {
            return;
        }
        if (signal == 1) {
            CURRENT_DIRECTORY = filename[0].getPath();
        } else {
            CURRENT_DIRECTORY2 = filename[0].getPath();
        }
        String win_file_title = "";
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filename.length; ++i) {
            sb.append(this.osf.getStringFromFile(filename[i], cur_encoding) + "\n\n");
            win_file_title = win_file_title + " " + filename[i].getName();
        }
        t.setText(sb.toString());
        if (signal == 1) {
            leftWindow = win_file_title;
        } else {
            rightWindow = win_file_title;
        }
        this.updateTitle();
    }

    private void saveText(int signal, JTextArea t) {
        JFileChooser sf;
        if (signal == 1) {
            sf = new JFileChooser(CURRENT_DIRECTORY);
            sf.setDialogTitle("Save left window as");
        } else {
            sf = new JFileChooser(CURRENT_DIRECTORY2);
            sf.setDialogTitle("Save right window as");
        }
        sf.setFileSelectionMode(0);
        int result = sf.showSaveDialog(this);
        if (result == 1) {
            return;
        }
        File filename = sf.getSelectedFile();
        if (filename == null || filename.getName().equals("")) {
            return;
        }
        String Text_to_write = t.getText();
        if (signal == 1) {
            CURRENT_DIRECTORY = filename.getPath();
        } else {
            CURRENT_DIRECTORY2 = filename.getPath();
        }
        try {
            OutputStreamWriter outf = cur_encoding.equals("ASCII") ? new OutputStreamWriter(new FileOutputStream(filename)) : new OutputStreamWriter((OutputStream)new FileOutputStream(filename), cur_encoding);
            outf.write(Text_to_write);
            ((Writer)outf).close();
            if (signal == 1) {
                leftWindow = filename.getName();
            } else {
                rightWindow = filename.getName();
            }
            this.updateTitle();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Error Saving File", "Error", 0);
        }
    }

    private static String readTextFromFile(File f, String encoding) {
        StringBuffer txt = new StringBuffer();
        try {
            int ch;
            InputStreamReader isr = new InputStreamReader(new FileInputStream(f));
            BufferedReader in = new BufferedReader(isr);
            while ((ch = ((Reader)in).read()) > -1) {
                txt.append((char)ch);
            }
            ((Reader)in).close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Error opening readme file", "Error", 0);
        }
        return txt.toString();
    }

    private void updateFile(File f, JTextArea t) {
        try {
            this.outf = new DataOutputStream(new FileOutputStream(f));
            String txt = t.getText();
            this.outf.writeBytes(txt);
            this.outf.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Error Opening File", "Error", 0);
        }
    }

    private String replaceSubstring(String origin_str, String old_substr, String new_substr) {
        int delim1 = origin_str.indexOf(old_substr);
        if (delim1 == -1) {
            return origin_str;
        }
        String head = origin_str.substring(0, delim1);
        String tail = origin_str.substring(delim1 + old_substr.length());
        return head + new_substr + tail;
    }

    protected void updateTitle() {
        this.setTitle("Left window = " + leftWindow + " ; Right window = " + rightWindow);
    }

    protected void updateStatusBar() {
        this.statusBar.setText(status_bar_text);
    }

    protected void updateStatusBar(String newText) {
        SwingUtilities.invokeLater(new Thread(){

            public void run() {
                WorkBenchBasic.this.statusBar.setText(WorkBenchBasic.this.newBarText);
            }
        });
    }

    public static void main(String[] args) {
        WorkBenchBasic f = new WorkBenchBasic();
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.setSize(850, 650);
        f.setLocation(40, 40);
        f.setVisible(true);
    }
}

