/*
 * Decompiled with CFR 0.152.
 */
package semtagger.welsh.webservice.client;

import java.util.StringTokenizer;
import semtagger.welsh.webservice.client.WelshTaggerSrv;
import semtagger.welsh.webservice.client.WelshTaggerSrv_Service;

public class WelshTaggerClient {
    private final int MAX_TAG_NUM = 3;

    public String semTagWnlt(String inWelshRawText, String username, String password) {
        WelshTaggerSrv_Service service = new WelshTaggerSrv_Service();
        WelshTaggerSrv port = service.getWelshTaggerSrvPort();
        String taggedText = port.semTagWnlt(inWelshRawText, username, password);
        taggedText = this.formatOutput(taggedText);
        return taggedText;
    }

    public String semTagWnlt(String inWelshRawText) {
        WelshTaggerSrv_Service service = new WelshTaggerSrv_Service();
        WelshTaggerSrv port = service.getWelshTaggerSrvPort();
        String taggedText = port.semTagWnlt(inWelshRawText, "corcenccusers", "corcencc3n5jkwd8g9f");
        taggedText = this.formatOutput(taggedText);
        return taggedText;
    }

    private String formatOutput(String inText) {
        StringTokenizer stk = new StringTokenizer(inText, "\n");
        StringBuilder sb = new StringBuilder();
        while (stk.hasMoreTokens()) {
            String[] items;
            String line = stk.nextToken().trim();
            if (line.length() == 0 || line.startsWith("#") || (items = line.split("\t")).length < 6) continue;
            String tok = items[0];
            String lem = items[1];
            String simpos = items[2];
            String semtags = items[3];
            String mwe = items[4];
            String pos = items[5];
            String[] semTagItems = semtags.split(" ");
            StringBuilder semtagsList = new StringBuilder();
            for (int i = 0; i < semTagItems.length && i < 3; ++i) {
                semtagsList.append(semTagItems[i] + " ");
            }
            semtags = semtagsList.toString().trim();
            sb.append(tok + "\t" + lem + "\t" + pos + "\t" + semtags + "\t" + mwe + "\r\n");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        WelshTaggerClient app = new WelshTaggerClient();
        String input = "Dechreuodd ei ddysgu bod cy yn rhaid i'w fab a dyn PuffinProduce dioddef broadband llawer, a gael ei wrthod gan yr henuriaid, prif otheiraidd ag ysgrifenyddion. A'i ladd. Ymhen tridiau, atgyfodi. Roedd yn llefaru'r gair hwn yn gwbl agored.";
        String output = app.semTagWnlt(input, "corcenccusers", "corcencc3n5jkwd8g9f");
        System.out.println(output);
    }
}

