/*
 * Decompiled with CFR 0.152.
 */
package ucrelsemtaggergui;

import ac.uk.lancs.ucrel.semtaggers.web.clients.SemanticTaggerClient;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import semtagger.welsh.webservice.client.WelshTaggerClient;
import ucrelsemtaggergui.OpenSaveFile;
import ucrelsemtaggergui.WorkBenchBasic;

public class UsasGUI
extends WorkBenchBasic {
    private String window_title = "Semantic Taggers Work Bench";
    private SemanticTaggerClient semagger = new SemanticTaggerClient();
    private WelshTaggerClient welSemagger = new WelshTaggerClient();
    private final String welTaggerUser = "corcenccusers";
    private final String welTaggerUserPswrd = "corcencc3n5jkwd8g9f";
    private File[] files = null;
    private int MAX_TAG_NUM = 3;
    private final int MAX_INPUT_SIZE = 10000;
    private final int MAX_CHI_INPUT_SIZE = 20000;
    private String filterCode;
    private JCheckBoxMenuItem useVardOption;
    private String useVard = "no";
    private int upperFilterYear = 9999;
    private int lowerFilterYear = 0;
    private JRadioButtonMenuItem format1;
    private JRadioButtonMenuItem format2;
    private JRadioButtonMenuItem format3;
    private OpenSaveFile osf;

    public UsasGUI() {
        super.setTitle(this.window_title);
        this.osf = new OpenSaveFile();
        try {
            this.addMenus();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.filterCode = "^" + this.lowerFilterYear + "_" + this.upperFilterYear + "_" + this.useVard + "\n";
    }

    private void addMenus() throws Exception {
        JMenu usas_menu = new JMenu("USAS");
        usas_menu.setToolTipText("USAS Multilingual taggers");
        this.jmb.add((Component)usas_menu, 2);
        JMenu htst_menu = new JMenu("HTST");
        htst_menu.setToolTipText("English historical thesaurus based tagger");
        this.jmb.add((Component)htst_menu, 3);
        JMenu settingMenu = new JMenu("HTST Setting");
        htst_menu.add(settingMenu);
        htst_menu.addSeparator();
        JMenu gostMenu = new JMenu("GOST");
        gostMenu.setToolTipText("English Gene Ontology Semantic Tagger");
        this.jmb.add((Component)gostMenu, 4);
        JMenu chiTaggerMenu = new JMenu("Chinese Semantic Tagger");
        usas_menu.add(chiTaggerMenu);
        JMenuItem text_semtag = new JMenuItem("Tag text in left window");
        chiTaggerMenu.add(text_semtag);
        text_semtag.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Thread semtagText = new Thread(){

                    public void run() {
                        Integer userCheck = UsasGUI.this.semagger.userCheck("guest-user", "guest-passwrd");
                        if (userCheck == null) {
                            JOptionPane.showMessageDialog(UsasGUI.this, "Internet connection problem.\n -- This software needs Internet access.", "Error", 0);
                            return;
                        }
                        WorkBenchBasic.status_bar_text = "Semantic-tagging text.";
                        UsasGUI.this.updateStatusBar();
                        String text = UsasGUI.this.jt1.getText();
                        text = text.replaceAll("\\s+", " ");
                        if (text.trim().length() > 0) {
                            text = text.length() > 20000 ? "[INPUT TEXT IS TOO BIG. MAXIMUM SIZE ALLOWED IS 20000 CHINESE CHARACTERS.]" : UsasGUI.this.semagger.tagChiText(text);
                        }
                        UsasGUI.this.jt2.setText(text);
                        WorkBenchBasic.status_bar_text = "Status Bar";
                        UsasGUI.this.updateStatusBar();
                    }
                };
                semtagText.start();
            }
        });
        JMenuItem file_semtag = new JMenuItem("Tag selected files");
        chiTaggerMenu.add(file_semtag);
        file_semtag.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Thread semtagFile = new Thread(){

                    public void run() {
                        Integer userCheck = UsasGUI.this.semagger.userCheck("guest-user", "guest-passwrd");
                        if (userCheck == null) {
                            JOptionPane.showMessageDialog(UsasGUI.this, "Internet connection problem.\n -- This software needs Internet access.", "Error", 0);
                            return;
                        }
                        File[] fs = UsasGUI.this.getFilesFromChooser("Select plain Chinese text files:", WorkBenchBasic.CURRENT_DIRECTORY);
                        if (fs == null) {
                            return;
                        }
                        WorkBenchBasic.CURRENT_DIRECTORY = fs[0].getParent();
                        for (int i = 0; i < fs.length; ++i) {
                            if (!fs[i].getName().endsWith(".txt")) continue;
                            WorkBenchBasic.status_bar_text = "Tagging file \"" + fs[i].getName() + "\".";
                            UsasGUI.this.updateStatusBar();
                            String text = UsasGUI.this.osf.getStringFromFile(fs[i], WorkBenchBasic.cur_encoding);
                            text = text.replaceAll("\\s+", " ");
                            text = text.length() > 20000 ? "[INPUT TEXT IS TOO BIG. MAXIMUM SIZE ALLOWED IS 20000 CHINESE CHARACTERS.]" : UsasGUI.this.semagger.tagChiText(text);
                            String newFPath = WorkBenchBasic.CURRENT_DIRECTORY + "/" + UsasGUI.this.changeFileNameSuff(fs[i].getName(), "csv");
                            UsasGUI.this.osf.saveTextToFile(text, newFPath, "UTF8");
                        }
                        WorkBenchBasic.status_bar_text = "Status Bar";
                        UsasGUI.this.updateStatusBar();
                    }
                };
                semtagFile.start();
            }
        });
        JMenu dutTaggerMenu = new JMenu("Dutch Semantic Tagger");
        usas_menu.addSeparator();
        usas_menu.add(dutTaggerMenu);
        JMenuItem dutSemtagText = new JMenuItem("Tag text in left window");
        dutTaggerMenu.add(dutSemtagText);
        dutSemtagText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Thread semtagText = new Thread(){

                    public void run() {
                        Integer userCheck = UsasGUI.this.semagger.userCheck("guest-user", "guest-passwrd");
                        if (userCheck == null) {
                            JOptionPane.showMessageDialog(UsasGUI.this, "Internet connection problem.\n -- This software needs Internet access.", "Error", 0);
                            return;
                        }
                        WorkBenchBasic.status_bar_text = "Semantic-tagging text.";
                        UsasGUI.this.updateStatusBar();
                        String text = UsasGUI.this.jt1.getText();
                        text = text.replaceAll("\\s+", " ");
                        if (text.trim().length() > 0) {
                            text = UsasGUI.this.isTooBig(text) ? "[INPUT TEXT IS TOO BIG. MAXIMUM SIZE ALLOWED IS 10000 TOKENS.]" : UsasGUI.this.semagger.tagDutText(text);
                        }
                        UsasGUI.this.jt2.setText(text);
                        WorkBenchBasic.status_bar_text = "Status Bar";
                        UsasGUI.this.updateStatusBar();
                    }
                };
                semtagText.start();
            }
        });
        JMenuItem dutSemtagFiles = new JMenuItem("Tag selected files");
        dutTaggerMenu.add(dutSemtagFiles);
        dutSemtagFiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Thread semtagFile = new Thread(){

                    public void run() {
                        Integer userCheck = UsasGUI.this.semagger.userCheck("guest-user", "guest-passwrd");
                        if (userCheck == null) {
                            JOptionPane.showMessageDialog(UsasGUI.this, "Internet connection problem.\n -- This software needs Internet access.", "Error", 0);
                            return;
                        }
                        File[] fs = UsasGUI.this.getFilesFromChooser("Select plain Dutch text files:", WorkBenchBasic.CURRENT_DIRECTORY);
                        if (fs == null) {
                            return;
                        }
                        WorkBenchBasic.CURRENT_DIRECTORY = fs[0].getParent();
                        for (int i = 0; i < fs.length; ++i) {
                            if (!fs[i].getName().endsWith(".txt")) continue;
                            WorkBenchBasic.status_bar_text = "Tagging file \"" + fs[i].getName() + "\".";
                            UsasGUI.this.updateStatusBar();
                            String text = UsasGUI.this.osf.getStringFromFile(fs[i], WorkBenchBasic.cur_encoding);
                            text = text.replaceAll("\\s+", " ");
                            text = UsasGUI.this.isTooBig(text) ? "[INPUT TEXT IS TOO BIG. MAXIMUM SIZE ALLOWED IS 10000 TOKENS.]" : UsasGUI.this.semagger.tagDutText(text);
                            String newFPath = WorkBenchBasic.CURRENT_DIRECTORY + "/" + UsasGUI.this.changeFileNameSuff(fs[i].getName(), "csv");
                            UsasGUI.this.osf.saveTextToFile(text, newFPath, "UTF8");
                        }
                        WorkBenchBasic.status_bar_text = "Status Bar";
                        UsasGUI.this.updateStatusBar();
                    }
                };
                semtagFile.start();
            }
        });
        JMenu frenchTaggerMenu = new JMenu("French Semantic Tagger");
        usas_menu.addSeparator();
        usas_menu.add(frenchTaggerMenu);
        JMenuItem frenchSemtagText = new JMenuItem("Tag text in left window");
        frenchTaggerMenu.add(frenchSemtagText);
        frenchSemtagText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Thread semtagText = new Thread(){

                    public void run() {
                        Integer userCheck = UsasGUI.this.semagger.userCheck("guest-user", "guest-passwrd");
                        if (userCheck == null) {
                            JOptionPane.showMessageDialog(UsasGUI.this, "Internet connection problem.\n -- This software needs Internet access.", "Error", 0);
                            return;
                        }
                        WorkBenchBasic.status_bar_text = "Semantic-tagging text.";
                        UsasGUI.this.updateStatusBar();
                        String text = UsasGUI.this.jt1.getText();
                        text = text.replaceAll("\\s+", " ");
                        if (text.trim().length() > 0) {
                            text = UsasGUI.this.isTooBig(text) ? "[INPUT TEXT IS TOO BIG. MAXIMUM SIZE ALLOWED IS 10000 TOKENS.]" : UsasGUI.this.semagger.tagFrenText(text);
                        }
                        UsasGUI.this.jt2.setText(text);
                        WorkBenchBasic.status_bar_text = "Status Bar";
                        UsasGUI.this.updateStatusBar();
                    }
                };
                semtagText.start();
            }
        });
        JMenuItem frenchSemtagFiles = new JMenuItem("Tag selected files");
        frenchTaggerMenu.add(frenchSemtagFiles);
        frenchSemtagFiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Thread semtagFile = new Thread(){

                    public void run() {
                        Integer userCheck = UsasGUI.this.semagger.userCheck("guest-user", "guest-passwrd");
                        if (userCheck == null) {
                            JOptionPane.showMessageDialog(UsasGUI.this, "Internet connection problem.\n -- This software needs Internet access.", "Error", 0);
                            return;
                        }
                        File[] fs = UsasGUI.this.getFilesFromChooser("Select plain French text files:", WorkBenchBasic.CURRENT_DIRECTORY);
                        if (fs == null) {
                            return;
                        }
                        WorkBenchBasic.CURRENT_DIRECTORY = fs[0].getParent();
                        for (int i = 0; i < fs.length; ++i) {
                            if (!fs[i].getName().endsWith(".txt")) continue;
                            WorkBenchBasic.status_bar_text = "Tagging file \"" + fs[i].getName() + "\".";
                            UsasGUI.this.updateStatusBar();
                            String text = UsasGUI.this.osf.getStringFromFile(fs[i], WorkBenchBasic.cur_encoding);
                            text = text.replaceAll("\\s+", " ");
                            text = UsasGUI.this.isTooBig(text) ? "[INPUT TEXT IS TOO BIG. MAXIMUM SIZE ALLOWED IS 10000 TOKENS.]" : UsasGUI.this.semagger.tagFrenText(text);
                            String newFPath = WorkBenchBasic.CURRENT_DIRECTORY + "/" + UsasGUI.this.changeFileNameSuff(fs[i].getName(), "csv");
                            UsasGUI.this.osf.saveTextToFile(text, newFPath, "UTF8");
                        }
                        WorkBenchBasic.status_bar_text = "Status Bar";
                        UsasGUI.this.updateStatusBar();
                    }
                };
                semtagFile.start();
            }
        });
        JMenu itaTaggerMenu = new JMenu("Italian Semantic Tagger");
        usas_menu.addSeparator();
        usas_menu.add(itaTaggerMenu);
        JMenuItem itaSemtagText = new JMenuItem("Tag text in left window");
        itaTaggerMenu.add(itaSemtagText);
        itaSemtagText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UsasGUI.this.updateStatusBar("Semantic-tagging text.");
                Thread semtag_text = new Thread(){

                    public void run() {
                        Integer userCheck = UsasGUI.this.semagger.userCheck("guest-user", "guest-passwrd");
                        if (userCheck == null) {
                            JOptionPane.showMessageDialog(UsasGUI.this, "Internet connection problem.\n -- This software needs Internet access.", "Error", 0);
                            return;
                        }
                        String text = UsasGUI.this.jt1.getText();
                        if ((text = text.replaceAll("\\s+", " ")).trim().length() > 0) {
                            text = UsasGUI.this.isTooBig(text) ? "[INPUT TEXT IS TOO BIG. MAXIMUM SIZE ALLOWED IS 10000 TOKENS.]" : UsasGUI.this.semagger.tagItaText(text);
                        }
                        UsasGUI.this.jt2.setText(text);
                        UsasGUI.this.updateStatusBar("Status Bar");
                    }
                };
                semtag_text.start();
            }
        });
        JMenuItem itaSemtagFiles = new JMenuItem("Tag selected files");
        itaTaggerMenu.add(itaSemtagFiles);
        itaSemtagFiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Thread semtagFile = new Thread(){

                    public void run() {
                        Integer userCheck = UsasGUI.this.semagger.userCheck("guest-user", "guest-passwrd");
                        if (userCheck == null) {
                            JOptionPane.showMessageDialog(UsasGUI.this, "Internet connection problem.\n -- This software needs Internet access.", "Error", 0);
                            return;
                        }
                        File[] fs = UsasGUI.this.getFilesFromChooser("Select plain Italian text files:", WorkBenchBasic.CURRENT_DIRECTORY);
                        if (fs == null) {
                            return;
                        }
                        WorkBenchBasic.CURRENT_DIRECTORY = fs[0].getParent();
                        for (int i = 0; i < fs.length; ++i) {
                            if (!fs[i].getName().endsWith(".txt")) continue;
                            WorkBenchBasic.status_bar_text = "Tagging " + fs[i].getName();
                            UsasGUI.this.updateStatusBar();
                            String text = UsasGUI.this.osf.getStringFromFile(fs[i], WorkBenchBasic.cur_encoding);
                            text = text.replaceAll("\\s+", " ");
                            text = UsasGUI.this.isTooBig(text) ? "[INPUT TEXT IS TOO BIG. MAXIMUM SIZE ALLOWED IS 10000 TOKENS.]" : UsasGUI.this.semagger.tagItaText(text);
                            String newFPath = WorkBenchBasic.CURRENT_DIRECTORY + "/" + UsasGUI.this.changeFileNameSuff(fs[i].getName(), "csv");
                            UsasGUI.this.osf.saveTextToFile(text, newFPath, "UTF8");
                        }
                        WorkBenchBasic.status_bar_text = "Status Bar";
                        UsasGUI.this.updateStatusBar();
                    }
                };
                semtagFile.start();
            }
        });
        JMenu portTaggerMenu = new JMenu("Portuguese Semantic Tagger");
        usas_menu.addSeparator();
        usas_menu.add(portTaggerMenu);
        JMenuItem portSemtagText = new JMenuItem("Tag text in left window");
        portTaggerMenu.add(portSemtagText);
        portSemtagText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Thread semtagText = new Thread(){

                    public void run() {
                        Integer userCheck = UsasGUI.this.semagger.userCheck("guest-user", "guest-passwrd");
                        if (userCheck == null) {
                            JOptionPane.showMessageDialog(UsasGUI.this, "Internet connection problem.\n -- This software needs Internet access.", "Error", 0);
                            return;
                        }
                        WorkBenchBasic.status_bar_text = "Semantic-tagging text.";
                        UsasGUI.this.updateStatusBar();
                        String text = UsasGUI.this.jt1.getText();
                        text = text.replaceAll("\\s+", " ");
                        if (text.trim().length() > 0) {
                            text = UsasGUI.this.isTooBig(text) ? "[INPUT TEXT IS TOO BIG. MAXIMUM SIZE ALLOWED IS 10000 TOKENS.]" : UsasGUI.this.semagger.tagPortText(text);
                        }
                        UsasGUI.this.jt2.setText(text);
                        WorkBenchBasic.status_bar_text = "Status Bar";
                        UsasGUI.this.updateStatusBar();
                    }
                };
                semtagText.start();
            }
        });
        JMenuItem portSemtagFiles = new JMenuItem("Tag selected files");
        portTaggerMenu.add(portSemtagFiles);
        portSemtagFiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Thread semtagFile = new Thread(){

                    public void run() {
                        Integer userCheck = UsasGUI.this.semagger.userCheck("guest-user", "guest-passwrd");
                        if (userCheck == null) {
                            JOptionPane.showMessageDialog(UsasGUI.this, "Internet connection problem.\n -- This software needs Internet access.", "Error", 0);
                            return;
                        }
                        File[] fs = UsasGUI.this.getFilesFromChooser("Select plain Portuguese text files:", WorkBenchBasic.CURRENT_DIRECTORY);
                        if (fs == null) {
                            return;
                        }
                        WorkBenchBasic.CURRENT_DIRECTORY = fs[0].getParent();
                        for (int i = 0; i < fs.length; ++i) {
                            if (!fs[i].getName().endsWith(".txt")) continue;
                            WorkBenchBasic.status_bar_text = "Tagging file \"" + fs[i].getName() + "\".";
                            UsasGUI.this.updateStatusBar();
                            String text = UsasGUI.this.osf.getStringFromFile(fs[i], WorkBenchBasic.cur_encoding);
                            text = text.replaceAll("\\s+", " ");
                            text = UsasGUI.this.isTooBig(text) ? "[INPUT TEXT IS TOO BIG. MAXIMUM SIZE ALLOWED IS 10000 TOKENS.]" : UsasGUI.this.semagger.tagPortText(text);
                            String newFPath = WorkBenchBasic.CURRENT_DIRECTORY + "/" + UsasGUI.this.changeFileNameSuff(fs[i].getName(), "csv");
                            UsasGUI.this.osf.saveTextToFile(text, newFPath, "UTF8");
                        }
                        WorkBenchBasic.status_bar_text = "Status Bar";
                        UsasGUI.this.updateStatusBar();
                    }
                };
                semtagFile.start();
            }
        });
        JMenu spanTaggersMenu = new JMenu("Spanish Semantic Taggers");
        usas_menu.addSeparator();
        usas_menu.add(spanTaggersMenu);
        JMenu spanTaggerMenu2 = new JMenu("Spanish Semantic Tagger (Grampal)");
        spanTaggersMenu.add(spanTaggerMenu2);
        JMenuItem spanSemtagText2 = new JMenuItem("Tag text in left window");
        spanTaggerMenu2.add(spanSemtagText2);
        spanSemtagText2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Thread semtagText = new Thread(){

                    public void run() {
                        Integer userCheck = UsasGUI.this.semagger.userCheck("guest-user", "guest-passwrd");
                        if (userCheck == null) {
                            JOptionPane.showMessageDialog(UsasGUI.this, "Internet connection problem.\n -- This software needs Internet access.", "Error", 0);
                            return;
                        }
                        WorkBenchBasic.status_bar_text = "Semantic-tagging text.";
                        UsasGUI.this.updateStatusBar();
                        String text = UsasGUI.this.jt1.getText();
                        text = text.replaceAll("\\s+", " ");
                        if (text.trim().length() > 0) {
                            text = UsasGUI.this.isTooBig(text) ? "[INPUT TEXT IS TOO BIG. MAXIMUM SIZE ALLOWED IS 10000 TOKENS.]" : UsasGUI.this.semagger.tagSpanTextGrampal(text);
                        }
                        UsasGUI.this.jt2.setText(text);
                        WorkBenchBasic.status_bar_text = "Status Bar";
                        UsasGUI.this.updateStatusBar();
                    }
                };
                semtagText.start();
            }
        });
        JMenuItem spanSemtagFiles2 = new JMenuItem("Tag selected files");
        spanTaggerMenu2.add(spanSemtagFiles2);
        spanSemtagFiles2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Thread semtagFile = new Thread(){

                    public void run() {
                        Integer userCheck = UsasGUI.this.semagger.userCheck("guest-user", "guest-passwrd");
                        if (userCheck == null) {
                            JOptionPane.showMessageDialog(UsasGUI.this, "Internet connection problem.\n -- This software needs Internet access.", "Error", 0);
                            return;
                        }
                        File[] fs = UsasGUI.this.getFilesFromChooser("Select plain Spanish text files:", WorkBenchBasic.CURRENT_DIRECTORY);
                        if (fs == null) {
                            return;
                        }
                        WorkBenchBasic.CURRENT_DIRECTORY = fs[0].getParent();
                        for (int i = 0; i < fs.length; ++i) {
                            if (!fs[i].getName().endsWith(".txt")) continue;
                            WorkBenchBasic.status_bar_text = "Tagging file \"" + fs[i].getName() + "\".";
                            UsasGUI.this.updateStatusBar();
                            String text = UsasGUI.this.osf.getStringFromFile(fs[i], WorkBenchBasic.cur_encoding);
                            text = text.replaceAll("\\s+", " ");
                            text = UsasGUI.this.isTooBig(text) ? "[INPUT TEXT IS TOO BIG. MAXIMUM SIZE ALLOWED IS 10000 TOKENS.]" : UsasGUI.this.semagger.tagSpanTextGrampal(text);
                            String newFPath = WorkBenchBasic.CURRENT_DIRECTORY + "/" + UsasGUI.this.changeFileNameSuff(fs[i].getName(), "csv");
                            UsasGUI.this.osf.saveTextToFile(text, newFPath, "UTF8");
                        }
                        WorkBenchBasic.status_bar_text = "Status Bar";
                        UsasGUI.this.updateStatusBar();
                    }
                };
                semtagFile.start();
            }
        });
        JMenu spanTaggerMenu = new JMenu("Spanish Semantic Tagger (TT)");
        spanTaggersMenu.add(spanTaggerMenu);
        JMenuItem spanSemtagText = new JMenuItem("Tag text in left window");
        spanTaggerMenu.add(spanSemtagText);
        spanSemtagText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Thread semtagText = new Thread(){

                    public void run() {
                        Integer userCheck = UsasGUI.this.semagger.userCheck("guest-user", "guest-passwrd");
                        if (userCheck == null) {
                            JOptionPane.showMessageDialog(UsasGUI.this, "Internet connection problem.\n -- This software needs Internet access.", "Error", 0);
                            return;
                        }
                        WorkBenchBasic.status_bar_text = "Semantic-tagging text.";
                        UsasGUI.this.updateStatusBar();
                        String text = UsasGUI.this.jt1.getText();
                        text = text.replaceAll("\\s+", " ");
                        if (text.trim().length() > 0) {
                            text = UsasGUI.this.isTooBig(text) ? "[INPUT TEXT IS TOO BIG. MAXIMUM SIZE ALLOWED IS 10000 TOKENS.]" : UsasGUI.this.semagger.tagSpanText(text);
                        }
                        UsasGUI.this.jt2.setText(text);
                        WorkBenchBasic.status_bar_text = "Status Bar";
                        UsasGUI.this.updateStatusBar();
                    }
                };
                semtagText.start();
            }
        });
        JMenuItem spanSemtagFiles = new JMenuItem("Tag selected files");
        spanTaggerMenu.add(spanSemtagFiles);
        spanSemtagFiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Thread semtagFile = new Thread(){

                    public void run() {
                        Integer userCheck = UsasGUI.this.semagger.userCheck("guest-user", "guest-passwrd");
                        if (userCheck == null) {
                            JOptionPane.showMessageDialog(UsasGUI.this, "Internet connection problem.\n -- This software needs Internet access.", "Error", 0);
                            return;
                        }
                        File[] fs = UsasGUI.this.getFilesFromChooser("Select plain Spanish text files:", WorkBenchBasic.CURRENT_DIRECTORY);
                        if (fs == null) {
                            return;
                        }
                        WorkBenchBasic.CURRENT_DIRECTORY = fs[0].getParent();
                        for (int i = 0; i < fs.length; ++i) {
                            if (!fs[i].getName().endsWith(".txt")) continue;
                            WorkBenchBasic.status_bar_text = "Tagging file \"" + fs[i].getName() + "\".";
                            UsasGUI.this.updateStatusBar();
                            String text = UsasGUI.this.osf.getStringFromFile(fs[i], WorkBenchBasic.cur_encoding);
                            text = text.replaceAll("\\s+", " ");
                            text = UsasGUI.this.isTooBig(text) ? "[INPUT TEXT IS TOO BIG. MAXIMUM SIZE ALLOWED IS 10000 TOKENS.]" : UsasGUI.this.semagger.tagSpanText(text);
                            String newFPath = WorkBenchBasic.CURRENT_DIRECTORY + "/" + UsasGUI.this.changeFileNameSuff(fs[i].getName(), "csv");
                            UsasGUI.this.osf.saveTextToFile(text, newFPath, "UTF8");
                        }
                        WorkBenchBasic.status_bar_text = "Status Bar";
                        UsasGUI.this.updateStatusBar();
                    }
                };
                semtagFile.start();
            }
        });
        JMenu swedishTaggerMenu = new JMenu("Swedish Semantic Tagger");
        usas_menu.addSeparator();
        usas_menu.add(swedishTaggerMenu);
        JMenuItem swedishSemtagText = new JMenuItem("Tag text in left window");
        swedishTaggerMenu.add(swedishSemtagText);
        swedishSemtagText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Thread semtagText = new Thread(){

                    public void run() {
                        Integer userCheck = UsasGUI.this.semagger.userCheck("guest-user", "guest-passwrd");
                        if (userCheck == null) {
                            JOptionPane.showMessageDialog(UsasGUI.this, "Internet connection problem.\n -- This software needs Internet access.", "Error", 0);
                            return;
                        }
                        WorkBenchBasic.status_bar_text = "Semantic-tagging text.";
                        UsasGUI.this.updateStatusBar();
                        String text = UsasGUI.this.jt1.getText();
                        text = text.replaceAll("\\s+", " ");
                        if (text.trim().length() > 0) {
                            text = UsasGUI.this.isTooBig(text) ? "[INPUT TEXT IS TOO BIG. MAXIMUM SIZE ALLOWED IS 10000 TOKENS.]" : UsasGUI.this.semagger.tagSwedText(text);
                        }
                        UsasGUI.this.jt2.setText(text);
                        WorkBenchBasic.status_bar_text = "Status Bar";
                        UsasGUI.this.updateStatusBar();
                    }
                };
                semtagText.start();
            }
        });
        JMenuItem swedishSemtagFiles = new JMenuItem("Tag selected files");
        swedishTaggerMenu.add(swedishSemtagFiles);
        swedishSemtagFiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Thread semtagFile = new Thread(){

                    public void run() {
                        Integer userCheck = UsasGUI.this.semagger.userCheck("guest-user", "guest-passwrd");
                        if (userCheck == null) {
                            JOptionPane.showMessageDialog(UsasGUI.this, "Internet connection problem.\n -- This software needs Internet access.", "Error", 0);
                            return;
                        }
                        File[] fs = UsasGUI.this.getFilesFromChooser("Select plain Swedish text files:", WorkBenchBasic.CURRENT_DIRECTORY);
                        if (fs == null) {
                            return;
                        }
                        WorkBenchBasic.CURRENT_DIRECTORY = fs[0].getParent();
                        for (int i = 0; i < fs.length; ++i) {
                            if (!fs[i].getName().endsWith(".txt")) continue;
                            WorkBenchBasic.status_bar_text = "Tagging file \"" + fs[i].getName() + "\".";
                            UsasGUI.this.updateStatusBar();
                            String text = UsasGUI.this.osf.getStringFromFile(fs[i], WorkBenchBasic.cur_encoding);
                            text = text.replaceAll("\\s+", " ");
                            text = UsasGUI.this.isTooBig(text) ? "[INPUT TEXT IS TOO BIG. MAXIMUM SIZE ALLOWED IS 10000 TOKENS.]" : UsasGUI.this.semagger.tagSwedText(text);
                            String newFPath = WorkBenchBasic.CURRENT_DIRECTORY + "/" + UsasGUI.this.changeFileNameSuff(fs[i].getName(), "csv");
                            UsasGUI.this.osf.saveTextToFile(text, newFPath, "UTF8");
                        }
                        WorkBenchBasic.status_bar_text = "Status Bar";
                        UsasGUI.this.updateStatusBar();
                    }
                };
                semtagFile.start();
            }
        });
        JMenu welTaggerMenu = new JMenu("Welsh Semantic Tagger");
        usas_menu.addSeparator();
        usas_menu.add(welTaggerMenu);
        JMenuItem welSemtagText = new JMenuItem("Tag text in left window");
        welTaggerMenu.add(welSemtagText);
        welSemtagText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorkBenchBasic.status_bar_text = "Semantic-tagging text.";
                UsasGUI.this.updateStatusBar();
                Thread semtag_text = new Thread(){

                    public void run() {
                        String text = UsasGUI.this.jt1.getText();
                        if ((text = text.replaceAll("\\s+", " ")).trim().length() > 0) {
                            text = UsasGUI.this.welSemagger.semTagWnlt(text, "corcenccusers", "corcencc3n5jkwd8g9f");
                        }
                        UsasGUI.this.jt2.setText(text);
                        WorkBenchBasic.status_bar_text = "Status Bar";
                        UsasGUI.this.updateStatusBar();
                    }
                };
                semtag_text.start();
            }
        });
        JMenuItem welSemtagFiles = new JMenuItem("Tag selected files");
        welTaggerMenu.add(welSemtagFiles);
        welSemtagFiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Thread semtag_file = new Thread(){

                    public void run() {
                        File[] fs = UsasGUI.this.getFilesFromChooser("Select plain Welsh text files:", WorkBenchBasic.CURRENT_DIRECTORY);
                        if (fs == null) {
                            return;
                        }
                        WorkBenchBasic.CURRENT_DIRECTORY = fs[0].getParent();
                        for (int i = 0; i < fs.length; ++i) {
                            if (!fs[i].getName().endsWith(".txt")) continue;
                            WorkBenchBasic.status_bar_text = "Tagging " + fs[i].getName();
                            UsasGUI.this.updateStatusBar();
                            String text = UsasGUI.this.osf.getStringFromFile(fs[i], WorkBenchBasic.cur_encoding);
                            text = text.replaceAll("\\s+", " ");
                            text = UsasGUI.this.welSemagger.semTagWnlt(text, "corcenccusers", "corcencc3n5jkwd8g9f");
                            String newFPath = WorkBenchBasic.CURRENT_DIRECTORY + "/" + UsasGUI.this.changeFileNameSuff(fs[i].getName(), "csv");
                            UsasGUI.this.osf.saveTextToFile(text, newFPath, "UTF8");
                        }
                        WorkBenchBasic.status_bar_text = "Status Bar";
                        UsasGUI.this.updateStatusBar();
                    }
                };
                semtag_file.start();
            }
        });
        JMenu engTaggerMenu = new JMenu("HTST Tagger");
        htst_menu.add(engTaggerMenu);
        JMenuItem engSemtagText = new JMenuItem("Tag text in left window");
        engTaggerMenu.add(engSemtagText);
        engSemtagText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UsasGUI.this.updateStatusBar("Tagging text.");
                Thread semtagText = new Thread(){

                    public void run() {
                        String text = UsasGUI.this.jt1.getText();
                        if ((text = text.replaceAll("\\s+", " ")).trim().length() > 0) {
                            try {
                                text = UsasGUI.this.semagger.tagEngTextFmt(UsasGUI.this.filterCode + text, 0);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                text = "[Error occurred and tagging failed]";
                            }
                        }
                        UsasGUI.this.jt2.setText(text);
                        UsasGUI.this.updateStatusBar("Status Bar");
                    }
                };
                semtagText.start();
            }
        });
        JMenuItem engSemtagFiles = new JMenuItem("Tag selected files");
        engTaggerMenu.add(engSemtagFiles);
        engSemtagFiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UsasGUI.access$502(UsasGUI.this, UsasGUI.this.getFilesFromChooser("Select plain English text files:", WorkBenchBasic.CURRENT_DIRECTORY));
                if (UsasGUI.this.files == null) {
                    return;
                }
                Thread processText = new Thread(){

                    public void run() {
                        WorkBenchBasic.CURRENT_DIRECTORY = UsasGUI.this.files[0].getParent();
                        for (int i = 0; i < UsasGUI.this.files.length; ++i) {
                            if (!UsasGUI.this.files[i].getName().endsWith(".txt")) continue;
                            UsasGUI.this.updateStatusBar("Tagging " + UsasGUI.this.files[i].getName());
                            String text = UsasGUI.this.osf.getStringFromFile(UsasGUI.this.files[i], WorkBenchBasic.cur_encoding);
                            text = text.replaceAll("\\s+", " ");
                            String taggedText = "";
                            if (text.trim().length() > 0) {
                                try {
                                    taggedText = UsasGUI.this.semagger.tagEngTextFmt(UsasGUI.this.filterCode + text, 0);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                            taggedText = taggedText.replaceAll("\n", "\r\n");
                            String newFPath = WorkBenchBasic.CURRENT_DIRECTORY + "/" + UsasGUI.this.changeFileNameSuff(UsasGUI.this.files[i].getName(), "csv");
                            UsasGUI.this.osf.saveTextToFile(taggedText, newFPath, WorkBenchBasic.cur_encoding);
                        }
                        UsasGUI.this.updateStatusBar("Status Bar");
                    }
                };
                processText.start();
            }
        });
        JMenuItem yearFilterMenuItem = new JMenuItem("Tagger Year Filter");
        settingMenu.add(yearFilterMenuItem);
        yearFilterMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Runnable yearFilterSettet = new Runnable(){

                    public void run() {
                        UsasGUI.this.display();
                    }
                };
                SwingUtilities.invokeLater(yearFilterSettet);
            }
        });
        settingMenu.addSeparator();
        this.useVardOption = new JCheckBoxMenuItem("Use Vard", false);
        settingMenu.add(this.useVardOption);
        this.useVardOption.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Runnable checkVardFlag = new Runnable(){

                    public void run() {
                        if (UsasGUI.this.useVardOption.getState()) {
                            UsasGUI.this.useVard = "yes";
                        } else {
                            UsasGUI.this.useVard = "no";
                        }
                        UsasGUI.this.filterCode = "^" + UsasGUI.this.lowerFilterYear + "_" + UsasGUI.this.upperFilterYear + "_" + UsasGUI.this.useVard + "\n";
                    }
                };
                SwingUtilities.invokeLater(checkVardFlag);
            }
        });
        JMenu engBioTagger = new JMenu("GOST tagger");
        gostMenu.add(engBioTagger);
        JMenuItem engBioSemtagText = new JMenuItem("Tag text in left window");
        engBioTagger.add(engBioSemtagText);
        engBioSemtagText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Thread semtagText = new Thread(){

                    public void run() {
                        Integer userCheck = UsasGUI.this.semagger.userCheck("guest-user", "guest-passwrd");
                        if (userCheck == null) {
                            JOptionPane.showMessageDialog(UsasGUI.this, "Internet connection problem.\n -- This software needs Internet access.", "Error", 0);
                            return;
                        }
                        WorkBenchBasic.status_bar_text = "Semantic-tagging text.";
                        UsasGUI.this.updateStatusBar();
                        String text = UsasGUI.this.jt1.getText();
                        text = text.replaceAll("\\s+", " ");
                        if (text.trim().length() > 0) {
                            if (UsasGUI.this.isTooBig(text)) {
                                text = "[INPUT TEXT IS TOO BIG. MAXIMUM SIZE ALLOWED IS 10000 TOKENS.]";
                            } else {
                                UsasGUI.this.semagger;
                                text = SemanticTaggerClient.tagEngBioText(text);
                            }
                        }
                        UsasGUI.this.jt2.setText(text);
                        WorkBenchBasic.status_bar_text = "Status Bar";
                        UsasGUI.this.updateStatusBar();
                    }
                };
                semtagText.start();
            }
        });
        JMenuItem engBioSemtagFiles = new JMenuItem("Tag selected files");
        engBioTagger.addSeparator();
        engBioTagger.add(engBioSemtagFiles);
        engBioSemtagFiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Thread semtagFile = new Thread(){

                    public void run() {
                        Integer userCheck = UsasGUI.this.semagger.userCheck("guest-user", "guest-passwrd");
                        if (userCheck == null) {
                            JOptionPane.showMessageDialog(UsasGUI.this, "Internet connection problem.\n -- This software needs Internet access.", "Error", 0);
                            return;
                        }
                        File[] fs = UsasGUI.this.getFilesFromChooser("Select English text files:", WorkBenchBasic.CURRENT_DIRECTORY);
                        if (fs == null) {
                            return;
                        }
                        WorkBenchBasic.CURRENT_DIRECTORY = fs[0].getParent();
                        for (int i = 0; i < fs.length; ++i) {
                            if (!fs[i].getName().endsWith(".txt")) continue;
                            WorkBenchBasic.status_bar_text = "Tagging file \"" + fs[i].getName() + "\".";
                            UsasGUI.this.updateStatusBar();
                            String text = UsasGUI.this.osf.getStringFromFile(fs[i], WorkBenchBasic.cur_encoding);
                            text = text.replaceAll("\\s+", " ");
                            if (UsasGUI.this.isTooBig(text)) {
                                text = "[INPUT TEXT IS TOO BIG. MAXIMUM SIZE ALLOWED IS 10000 TOKENS.]";
                            } else {
                                UsasGUI.this.semagger;
                                text = SemanticTaggerClient.tagEngBioText(text);
                            }
                            String newFPath = WorkBenchBasic.CURRENT_DIRECTORY + "/" + UsasGUI.this.changeFileNameSuff(fs[i].getName(), "csv");
                            UsasGUI.this.osf.saveTextToFile(text, newFPath, "UTF8");
                        }
                        WorkBenchBasic.status_bar_text = "Status Bar";
                        UsasGUI.this.updateStatusBar();
                    }
                };
                semtagFile.start();
            }
        });
    }

    private void display() {
        JTextField field1 = new JTextField("" + this.upperFilterYear);
        JTextField field2 = new JTextField("" + this.lowerFilterYear);
        JPanel panel = new JPanel(new GridLayout(0, 1));
        panel.add(new JLabel("Enter Filtering Years:"));
        panel.add(new JLabel("Upper Year:"));
        panel.add(field1);
        panel.add(new JLabel("Lower Year:"));
        panel.add(field2);
        int result = JOptionPane.showConfirmDialog(this, panel, "Tagger Filter Time", 2, -1);
        if (result == 0) {
            try {
                this.upperFilterYear = Integer.parseInt(field1.getText());
                this.lowerFilterYear = Integer.parseInt(field2.getText());
                this.filterCode = "^" + this.lowerFilterYear + "_" + this.upperFilterYear + "_" + this.useVard + "\n";
            }
            catch (NumberFormatException e) {
                return;
            }
        } else {
            return;
        }
    }

    private boolean isTooBig(String txt) {
        StringTokenizer stk = new StringTokenizer(txt, " \t\n");
        return stk.countTokens() > this.MAX_INPUT_SIZE;
    }

    String changeFileNameSuff(String infName, String newSuf) {
        int n = infName.lastIndexOf(46);
        if (n >= 0) {
            infName = infName.substring(0, n + 1);
        }
        return infName + newSuf;
    }

    private String formatHtstOutput(String input) {
        StringTokenizer stk = new StringTokenizer(input, "\n");
        StringBuilder sb = new StringBuilder();
        while (stk.hasMoreTokens()) {
            String[] items;
            String line = stk.nextToken().trim();
            if (line.length() == 0 || line.startsWith("#") || (items = line.split("\t")).length < 7) continue;
            sb.append(items[0] + "\t" + items[1] + "\t" + items[2] + "\t" + items[3] + "\t" + items[4] + "\t" + items[6] + "\n");
        }
        return sb.toString();
    }

    private String formatOutput(String inText) {
        StringTokenizer stk = new StringTokenizer(inText, "\n");
        StringBuilder sb = new StringBuilder();
        while (stk.hasMoreTokens()) {
            String[] items;
            String line = stk.nextToken().trim();
            if (line.length() == 0 || line.startsWith("#") || (items = line.split("\t")).length < 5) continue;
            String tok = items[0];
            String lem = items[1];
            String pos = items[2];
            String semtags = items[3];
            String mwe = items[4];
            String[] semTagItems = semtags.split(" ");
            StringBuilder semtagsList = new StringBuilder();
            for (int i = 0; i < semTagItems.length && i < this.MAX_TAG_NUM; ++i) {
                semtagsList.append(semTagItems[i] + " ");
            }
            semtags = semtagsList.toString().trim();
            sb.append(tok + "\t" + lem + "\t" + pos + "\t" + semtags + "\t" + mwe + "\r\n");
        }
        return sb.toString();
    }

    private String formatOutput2(String inText) {
        StringTokenizer stk = new StringTokenizer(inText, "\n");
        StringBuilder sb = new StringBuilder();
        while (stk.hasMoreTokens()) {
            String[] items;
            String line = stk.nextToken().trim();
            if (line.length() == 0 || line.startsWith("#") || (items = line.split("\t")).length < 6) continue;
            String tok = items[0];
            String lem = items[1];
            String simpos = items[2];
            String semtags = items[3];
            String mwe = items[4];
            String pos = items[5];
            String[] semTagItems = semtags.split(" ");
            StringBuilder semtagsList = new StringBuilder();
            for (int i = 0; i < semTagItems.length && i < this.MAX_TAG_NUM; ++i) {
                semtagsList.append(semTagItems[i] + " ");
            }
            semtags = semtagsList.toString().trim();
            sb.append(tok + "\t" + lem + "\t" + pos + "\t" + semtags + "\t" + mwe + "\r\n");
        }
        return sb.toString();
    }

    private String formatWelshOutput(String inText) {
        StringTokenizer stk = new StringTokenizer(inText, "\n");
        StringBuilder sb = new StringBuilder();
        while (stk.hasMoreTokens()) {
            String[] items;
            String line = stk.nextToken().trim();
            if (line.length() == 0 || line.startsWith("#") || (items = line.split("\t")).length != 6) continue;
            String tok = items[0];
            String lem = items[1];
            String simPos = items[2];
            String semtags = items[3];
            String mwe = items[4];
            String origPos = items[5];
            String[] semTagItems = semtags.split(" ");
            StringBuilder semtagsList = new StringBuilder();
            for (int i = 0; i < semTagItems.length && i < this.MAX_TAG_NUM; ++i) {
                semtagsList.append(semTagItems[i] + " ");
            }
            semtags = semtagsList.toString().trim();
            sb.append(tok + "\t" + lem + "\t" + origPos + "\t" + semtags + "\t" + mwe + "\t" + "\n");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        UsasGUI uwb = new UsasGUI();
        uwb.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        uwb.setSize(850, 650);
        uwb.setLocation(40, 40);
        uwb.setVisible(true);
    }

    static /* synthetic */ File[] access$502(UsasGUI x0, File[] x1) {
        x0.files = x1;
        return x1;
    }
}

