/*
 * Decompiled with CFR 0.152.
 */
package ac.uk.lancs.ucrel.semtaggers.web.clients;

import java.util.StringTokenizer;
import uk.ac.lancs.ucrel.semantictagger.soap.UcrelSemTaggerSoap;
import uk.ac.lancs.ucrel.semantictagger.soap.UcrelSemTaggerSoapService;

public class SemanticTaggerClient {
    private final int MAX_TAG_NUM = 3;

    public Integer userCheck(String userID, String password) {
        UcrelSemTaggerSoapService service = new UcrelSemTaggerSoapService();
        UcrelSemTaggerSoap port = service.getUcrelSemTaggerSoapPort();
        return port.userCheck(userID, password);
    }

    public String tagSpanText(String inText) {
        UcrelSemTaggerSoapService service = new UcrelSemTaggerSoapService();
        UcrelSemTaggerSoap port = service.getUcrelSemTaggerSoapPort();
        String taggedText = port.tagSpanText(inText);
        taggedText = this.formatOutput(taggedText);
        return taggedText;
    }

    public String tagSpanTextGrampal(String inputText) {
        UcrelSemTaggerSoapService service = new UcrelSemTaggerSoapService();
        UcrelSemTaggerSoap port = service.getUcrelSemTaggerSoapPort();
        String taggedText = port.tagSpanTextGrampal(inputText);
        taggedText = this.formatOutput(taggedText);
        return taggedText;
    }

    public String tagChiText(String inputText) {
        UcrelSemTaggerSoapService service = new UcrelSemTaggerSoapService();
        UcrelSemTaggerSoap port = service.getUcrelSemTaggerSoapPort();
        String taggedText = port.tagChiText(inputText);
        taggedText = this.formatOutput(taggedText);
        return taggedText;
    }

    public String tagItaText(String inputText) {
        UcrelSemTaggerSoapService service = new UcrelSemTaggerSoapService();
        UcrelSemTaggerSoap port = service.getUcrelSemTaggerSoapPort();
        String taggedText = port.tagItaText(inputText);
        taggedText = this.formatOutput(taggedText);
        return taggedText;
    }

    public String tagDutText(String inputText) {
        UcrelSemTaggerSoapService service = new UcrelSemTaggerSoapService();
        UcrelSemTaggerSoap port = service.getUcrelSemTaggerSoapPort();
        String taggedText = port.tagDutText(inputText);
        taggedText = this.formatOutput(taggedText);
        return taggedText;
    }

    public String tagPortText(String inputText) {
        UcrelSemTaggerSoapService service = new UcrelSemTaggerSoapService();
        UcrelSemTaggerSoap port = service.getUcrelSemTaggerSoapPort();
        String taggedText = port.tagPortText(inputText);
        taggedText = this.formatOutput(taggedText);
        return taggedText;
    }

    public String tagFrenText(String inText) {
        UcrelSemTaggerSoapService service = new UcrelSemTaggerSoapService();
        UcrelSemTaggerSoap port = service.getUcrelSemTaggerSoapPort();
        String taggedText = port.tagFrenText(inText);
        taggedText = this.formatOutput(taggedText);
        return taggedText;
    }

    public String tagEngText(String inputText) {
        UcrelSemTaggerSoapService service = new UcrelSemTaggerSoapService();
        UcrelSemTaggerSoap port = service.getUcrelSemTaggerSoapPort();
        String taggedText = port.tagEngText(inputText);
        taggedText = taggedText != null ? this.formatHtstOutput(taggedText) : "[English tagger has problem. Please contact the developer or try later.]";
        return taggedText;
    }

    public String tagEngTextFmt(String inputText, int formatFlag) {
        UcrelSemTaggerSoapService service = new UcrelSemTaggerSoapService();
        UcrelSemTaggerSoap port = service.getUcrelSemTaggerSoapPort();
        String taggedText = port.tagEngTextFmt(inputText, formatFlag);
        taggedText = taggedText != null ? this.formatHtstOutput(taggedText) : "[English tagger has problem. Please contact the developer or try later.]";
        return taggedText;
    }

    public static String tagEngBioText(String inputText) {
        UcrelSemTaggerSoapService service = new UcrelSemTaggerSoapService();
        UcrelSemTaggerSoap port = service.getUcrelSemTaggerSoapPort();
        String taggedText = port.tagEngBioText(inputText);
        if (taggedText.trim().length() == 0) {
            return "[ERROR: NO TAGGED RESULT RETURNED]";
        }
        return taggedText;
    }

    public String tagSwedText(String inputText) {
        UcrelSemTaggerSoapService service = new UcrelSemTaggerSoapService();
        UcrelSemTaggerSoap port = service.getUcrelSemTaggerSoapPort();
        String taggedText = port.tagSwedText(inputText);
        taggedText = this.formatOutput(taggedText);
        return taggedText;
    }

    private String formatHtstOutput(String input) {
        StringTokenizer stk = new StringTokenizer(input, "\n");
        StringBuilder sb = new StringBuilder();
        while (stk.hasMoreTokens()) {
            String[] items;
            String line = stk.nextToken().trim();
            if (line.length() == 0 || line.startsWith("#") || (items = line.split("\t")).length < 7) continue;
            sb.append(items[0] + "\t" + items[1] + "\t" + items[2] + "\t" + items[3] + "\t" + items[4] + "\t" + items[6] + "\n");
        }
        return sb.toString();
    }

    private String formatOutput(String inText) {
        StringTokenizer stk = new StringTokenizer(inText, "\n");
        StringBuilder sb = new StringBuilder();
        while (stk.hasMoreTokens()) {
            String[] items;
            String line = stk.nextToken().trim();
            if (line.length() == 0 || line.startsWith("#") || (items = line.split("\t")).length < 6) continue;
            String tok = items[0];
            String lem = items[1];
            String simpos = items[2];
            String semtags = items[3];
            String mwe = items[4];
            String pos = items[5];
            String[] semTagItems = semtags.split(" ");
            StringBuilder semtagsList = new StringBuilder();
            for (int i = 0; i < semTagItems.length && i < 3; ++i) {
                semtagsList.append(semTagItems[i] + " ");
            }
            semtags = semtagsList.toString().trim();
            sb.append(tok + "\t" + lem + "\t" + pos + "\t" + semtags + "\t" + mwe + "\r\n");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        SemanticTaggerClient app = new SemanticTaggerClient();
        String chitxt = "\u4ff1\u4e50\u90e8\u753123\u683c\u96f7\u6cfd\u5bb6\u65cf\u638c\u7ba1\uff0c\u4ed6\u4eec\u5728\u8d5e\u52a9\u5546\u3001\u5546\u54c1\u9500\u552e\u548c\u5546\u6807\u6ce8\u518c\u65b9\u9762\u5927\u5927\u589e\u957f\uff0c\u4e00\u4e1d\u5149\u7ebf\uff0c \u5e76\u521b\u4e0b\u4e861.46\u4ebf\u82f1\u9551\u7684\u5229\u6da6\u3002\u8be5\u6570\u636e\u662f\u81ea\u83ab\u8036\u65af\u4e0a\u8d5b\u5b63\u672b\u63a5\u73ed\u5f17\u683c\u68ee\u4e4b\u540e\u7b2c\u4e00\u6b21\u53d1\u5e03\u7684\u3002";
        String itatxt = "Non si al mondo capisce se per una malintesa carit\u00e0 di patria o per un ormai inspiegabile timore reverenziale, accanirsi contro fatto sta che il ritorno di Mario Monti alla presidenza della Bocconi non ha raccolto tutti i commenti che avrebbe meritato, e dell appropriato tenore.";
        String duttxt = "Wij vinden het belangrijk dat u weet wat te doen in het land waar u heen reist. Daarom staat het routeboek ook vol handige informatie als nuttige adressen, brandstof, verkeersvoorschriften, valuta en grensformaliteiten. Zo bent u goed voorbereid op het land en de regio\u2019s waar u komt tijdens uw kampeerreis.";
        String portxt = "Esta documentaci\u00f3n fue elaborada a partir de la documentaci\u00f3n del proyecto FreeLing.";
        String espText = "Manuel S\u00e1nchez, alem\u00e1n artesano de Artifex, zamorano contaba poco antes de recibir el galard\u00f3n ayer noche, c\u00f3mo se engendr\u00f3 el tipo.";
        String engtxt = "This is for test only. Take a look at the result.";
        String frentxt = "Les chevaliers de la table ronde constituent un ordre l\u00e9gendaire au service du mythique roi Arthur que ce dernier a charg\u00e9 de mener.";
        String swedtxt = "Det \u00e4r mycket besv\u00e4rligt v\u00e4glag, vi uppmanar trafikanter att k\u00f6ra f\u00f6rsiktigt.";
        String bioEngText = "In experiment on anaphase, we found the myeloid dendritic cell activation in the experiment.";
        Integer userCheckResult = app.userCheck("userId", "myPasWrd");
        String txt = "";
        txt = userCheckResult == null ? "Please check internet connection." : (userCheckResult == 1 ? SemanticTaggerClient.tagEngBioText(bioEngText) : "[Unauthorised User Error]");
        System.out.println(txt);
    }
}

